<?php
//inlcude headers
require_once('../../common/header.php');

if ($_SERVER['REQUEST_METHOD'] === "POST") {

  $data = json_decode(file_get_contents("php://input"));

  if (!empty($data)) {

    $church_id = '';
    if($data->church === 'Others'){
      $content_obj->name = $data->church_name?? '';
      $content_obj->pastor_name = $data->pastor_name?? '';
      $content_obj->pincode = $data->church_pincode?? '';
      $content_obj->state = $data->church_state?? '';
      $content_obj->city = $data->church_city?? '';
      $content_obj->district = $data->church_district?? '';
      $church_id = $content_obj->addChurch();

    }

    // set user property values with validation
    $user_obj->artist_id = $data->artist_id ?? '';
    $user_obj->name = $data->name ?? '';
    $user_obj->email = $data->email ?? '';
    $user_obj->phone = $data->phone ?? '';
    $user_obj->gender = $data->gender ?? '';
    $user_obj->country = $data->country ?? '';
    $user_obj->state = $data->state ?? '';
    $user_obj->city = $data->city ?? '';
    $user_obj->district = $data->district ?? '';
    $user_obj->church = $church_id ? $church_id: $data->church;
    $user_obj->pincode = $data->pincode ?? '';
    
    // $user_obj->otherChurch = $data->otherChurch ?? '';
    $user_obj->add_date = date('Y-m-d');
    $user_obj->add_time = date('H:i:s');
    
    // Check if phone number exists
    $phone = $user_obj->phoneExists();
    if (!empty($phone)) {
      http_response_code(500);
      echo json_encode(array("status" => 0, "msg" => "Phone Number Already Exists"));
      exit();
    }
    
    // Check if Email exists
    $email_data = $user_obj->check_email();
    if (!empty($email_data)) {
      
      http_response_code(500);
      echo json_encode(array(
        "status" => 0,
        "message" => "User already exists, try another email address"
      ));
    } else {

      $user = $user_obj->create_user();
      if ($user) {
        if(is_array($data->artist_id)){
          foreach($data->artist_id as $id){
            $user_obj->cus_id = $user;
            $user_obj->artist_id = $id;
            $addalbum = $user_obj->AddFollower();
          }
        }
        
        $result = EmailUtility::sendEmail(
        $data->email,
        'Registration Succesfull!',
          ' 
            <p> Welcome '.$data->name.'</p>
            <p>Thank you for registering with <strong>Rejoice Music</strong>.</p>
            <p>Your account has been successfully created and you are now part of our community.</p>
            <p>You can now log in and start using all the features we have to offer.</p>
          '
      );

        http_response_code(200);
        echo json_encode(array(
          "status" => 1,
          "message" => "User has been created"
        ));
      } else {
        http_response_code(500);
        echo json_encode(array(
          "status" => 0,
          "message" => "Failed to save user"
        ));
      }
    }
  } else {
    http_response_code(500);
    echo json_encode(array(
      "status" => 0,
      "message" => "All data needed"
    ));
  }
} else {
  http_response_code(503);
  echo json_encode(array(
    "status" => 0,
    "message" => "Access Denied"
  ));
}
