<?php
require_once('../../common/header.php');

use Rakit\Validation\Validator;

$data = json_decode(file_get_contents("php://input"), true);

if (!is_array($data)) {
    echo json_encode(["status" => "error", "message" => "Invalid input data"]);
    exit;
}

$validator = new Validator;
$validation = $validator->make($data, [
    'pincode' => 'required|max:6|min:6',
]);

$validation->validate();

if ($validation->fails()) {
    $errors = $validation->errors();
    echo json_encode(["status" => 'error', "errors" => $errors->firstOfAll()]);
    exit;
}

$pincode = $data['pincode'];
$api_url = 'https://api.postalpincode.in/pincode/' . $pincode;

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

$apiResult = json_decode($response, true);

$localities = [];

if (isset($apiResult[0]['Status']) && $apiResult[0]['Status'] === 'Success' && !empty($apiResult[0]['PostOffice'])) {
    foreach ($apiResult[0]['PostOffice'] as $postOffice) {

        $localities['country'] = [
            'id' => 1,
            'name' => $postOffice['Country'] ?? 'India'
        ];

        // Handle City
        if (!empty($postOffice['Block'])) {
            $content_obj->city = $postOffice['Block'];
            $city = $content_obj->getCityByName();
            if ($city->rowCount() > 0) {
                $city = $city->fetch(PDO::FETCH_ASSOC);
                $localities['city'] = [
                    'id' => $city['rj_city_id'],
                    'name' => $city['rj_city_name']
                ];
            } else {
                $cityId = $content_obj->insertCity(); // set ->city before this
                $localities['city'] = [
                    'id' => $cityId,
                    'name' => $content_obj->city
                ];
            }
        }

        // Handle State
        if (!empty($postOffice['State'])) {
            $content_obj->state = $postOffice['State'];
            $state = $content_obj->getStateByName();
            if ($state->rowCount() > 0) {
                $state = $state->fetch(PDO::FETCH_ASSOC);
                $localities['state'] = [
                    'id' => $state['rj_state_id'],
                    'name' => $state['rj_state_name']
                ];
                $content_obj->state_id = $state['rj_state_id'];
            } 
        }

        // Handle District
        if (!empty($postOffice['District'])) {
            $content_obj->district = $postOffice['District'];
            $district = $content_obj->getDistrictByName();
            if ($district->rowCount() > 0) {
                $district = $district->fetch(PDO::FETCH_ASSOC);
                $localities['district'] = [
                    'id' => $district['rj_district_id'],
                    'name' => $district['rj_district_name']
                ];
            } else {
                $districtId = $content_obj->insertDistrict(); // assumes ->district and ->state_id are set
                $localities['district'] = [
                    'id' => $districtId,
                    'name' => $content_obj->district
                ];
            }
        }
    }

    echo json_encode(["status" => "Success", "geolocation" => $localities]);
} else {
    echo json_encode(["status" => "error", "message" => "No results found for this pincode."]);
}
