<?php
//inlcude headers
require_once('../../common/header.php');
require_once('../../common/request.php');


$validate = validateToken();
if ($validate) {
    $user = $validate->data;
    $deatils = $artist_obj->ProfileDetail($user->id);

    $podcast_obj->artist_id = $user->id;
    if (!empty($deatils)) {
        $podcast_obj->limit = $_GET['limit']??10;
        $podcast_obj->offset = $_GET['offset']??0;
        $podcast_obj->search = $_GET['search']??null;

        $stmt = $podcast_obj->UpcomingPodcast();
        $itemCount = $stmt->rowCount();

        $total = $podcast_obj->artistUpcomingPodcast();
        // $total = $total->rowCount();

        if ($itemCount > 0) {
            $data = array();
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        
                $date = $row['rj_podcast_date'];
                $rj_podcast_status = $row['rj_podcast_status'];
                $rj_podcast_live_status = $row['rj_podcast_live_status'];
                $rj_podcast_cover = $row['rj_podcast_cover'];
        
                if ($rj_podcast_status == '0') {
                    $status = 'Pending';
                } else if ($rj_podcast_status == '2') {
                    $status = 'Cancelled, Kindly Re Schedule';
                } else {
                    $status = 'Approved';
                }
        
                $newDates = date("Y-m-d H:i:s", strtotime($date));
                $newDate = date("d M Y h:i A", strtotime($date));
                $newDate1 = date("d M Y", strtotime($date));
                $newDate2 = date("h:i:s", strtotime($date));
        
                $time = strtotime($newDates);
                $startTime = date("Y-m-d H:i:s", strtotime('+10 minutes', $time));
                $startingTime = date("Y-m-d H:i:s", strtotime('-10 minutes', $time));
                $dates = date('Y-m-d H:i:s');
        
        
                $start_date = new DateTime("$dates");
                $since_start = $start_date->diff(new DateTime("$newDates"));
                $since_start->i . ' minutes<br>';
        
                // Default status
                $statussss = "Upcoming";

                // Case 1: Podcast is completed manually
                if ($rj_podcast_live_status == 3) {
                    $statussss = "Completed";
                }
                // Case 2: Current time is between scheduled time and 10 minutes after
                else if ($dates >= $newDates && $dates <= $startTime) {
                    $statussss = "Live";
                }
                // Case 3: Current time is between 10 minutes before and the scheduled time
                else if ($dates >= $startingTime && $dates < $newDates) {
                    $statussss = "Going To Start";
                }
                // Case 4: Time has passed beyond the start window, but status is not marked as completed/live
                else if ($dates > $startTime && !in_array($rj_podcast_live_status, [1, 3])) {
                    $statussss = "Cancelled";
                }
                // Case 5: If none of the above, it's still upcoming
                else if ($dates < $startingTime) {
                    $statussss = "Upcoming";
                }
        
                $data[] = array(
                    "podcast_id" => $row['rj_podcast_id'],
                    "podcast_unique_id" => 'RJ_Live_' . $row['rj_podcast_id'],
                    "podcast_title" => $row['rj_podcast_title'],
                    "rj_podcast_category_title" => $row['rj_podcast_category_title'],
                    "rj_podcast_category_id" =>  $row['rj_podcast_category_id'],
                    "rj_podcast_type" => $row['rj_podcast_type'],
                    "live_time" => $newDate,
                    "scheduled_date" => $newDate1,
                    "scheduled_time" => $newDate2,
                    "cover" => $rj_podcast_cover,
                    "status" => $status,
                    "pod_status" => $statussss,
                    "podcast_end_time" => $startTime,
                    "duration" => $row['rj_podcast_duration'],
                    "podcast_link" => $row['rj_podcast_link']

                );
            }
        } else {
            $data = array();
        }
                
        echo json_encode(array("status" => "Success", "Upcoming_List" => $data, 'total' => $total->rowCount()));
        
    }
}