<?php
//inlcude headers
require_once('../../common/header.php');

use Firebase\JWT\JWT;

if ($_SERVER['REQUEST_METHOD'] === "POST") {

  $data = json_decode(file_get_contents("php://input"));

  if (!empty($data->phone) && !empty($data->password)) {

    $artist_obj->phone = $data->phone;

    $user_data = $artist_obj->check_login();

    if (!empty($user_data)) {
      $email = $user_data['rj_artist_phone'];
      $password = $user_data['rj_artist_password'];

      if ($user_data['approve_status'] == 0) {
        echo json_encode(['status' => false, 'message' => 'Artist account is not verified..']);
        exit;
      }

      if (password_verify($data->password, $password)) { // normal password, hashed password

        $iss = "localhost";
        $iat = time();
        $nbf = $iat;
        $exp = $iat + (30 * 24 * 60 * 60);
        $aud = "myusers";
        $user_arr_data = array(
          "id" => $user_data['rj_artist_id'],
          "name" => $user_data['rj_artist_name'],
          "email" => $user_data['rj_artist_email'],
          "phone" => $user_data['rj_artist_phone']
        );

        $secret_key = "EBEqjOBupNnWUYG9eQBGvUM8";

        $payload_info = array(
          "iss" => $iss,
          "iat" => $iat,
          "nbf" => $nbf,
          "exp" => $exp,
          "aud" => $aud,
          "data" => $user_arr_data
        );

        $jwt = JWT::encode($payload_info, $secret_key, 'HS512');

        http_response_code(200);
        echo json_encode(array(
          "status" => true,
          "jwt" => $jwt,
          "message" => "User logged in successfully"
        ));
      } else {

        http_response_code(404);
        echo json_encode(array(
          "status" => 0,
          "message" => "Invalid credentials"
        ));
      }
    } else {
      http_response_code(404);
      echo json_encode(array(
        "status" => 0,
        "message" => "Invalid credentials"
      ));
    }
  } else {
    http_response_code(404);
    echo json_encode(array(
      "status" => 0,
      "message" => "All data needed"
    ));
  }
}
