<?php
//inlcude headers
require_once('../../common/header.php');
require_once('../../common/request.php');


if ($_SERVER['REQUEST_METHOD'] === "POST") {

    $validate = validateToken();

    if ($validate) {
        $data = json_decode(file_get_contents("php://input"));
        $user = $validate->data;
        if (!empty($data)) {
            $existinguserData = $artist_obj->getUserData($user->id);
            
            if (!$existinguserData) {
                http_response_code(404);
                echo json_encode(['status' => false, 'message' => 'User not found']);
            } else {

                $artist_obj->name = $data->name ?? '';
                $artist_obj->email = $data->email ?? '';
                $artist_obj->phone = $data->phone ?? '';
                $artist_obj->gender = $data->gender ?? '';
                $artist_obj->dob = !empty($data->dob) ? date('Y-m-d', strtotime($data->dob)) : null;
                $artist_obj->address = $data->address ?? '';
                $artist_obj->country = $data->country ?? '';
                $artist_obj->state = $data->state ?? '';
                $artist_obj->district = $data->district ?? '';
                $artist_obj->city = $data->city ?? '';
                $artist_obj->church = $data->church ?? '';
                $artist_obj->rj_artist_pincode = $data->rj_artist_pincode ?? '';
                $artist_obj->rj_artist_landmark = $data->rj_artist_landmark ?? '';
                $artist_obj->artist_id = $user->id;
        
                if ($artist_obj->updateProfile()) {
                    http_response_code(200);
                    echo json_encode(['status' => true, 'message' => 'User Profile Updated Successfully']);
                } else {
                    http_response_code(500);
                    echo json_encode(['status' => false, 'message' => 'User Profile Update Failed']);
                }
            }
        }
    }
}
