<?php
//inlcude headers
require_once('../../common/header.php');

use Rakit\Validation\Validator;

if ($_SERVER['REQUEST_METHOD'] === "POST") {

  $data = json_decode(file_get_contents("php://input"));

  if (!empty($data)) {

    // set user property values with validation
    $artist_obj->name = $data->name ?? '';
    $artist_obj->email = $data->email ?? '';
    $artist_obj->phone = $data->phone ?? '';
    $artist_obj->gender = $data->gender ?? '';
    $artist_obj->dob = !empty($data->dob) ? date('Y-m-d', strtotime($data->dob)) : null;
    $artist_obj->address = $data->address ?? '';
    $artist_obj->country = $data->country ?? '';
    $artist_obj->state = $data->state ?? '';
    $artist_obj->district = $data->district ?? '';
    $artist_obj->city = $data->city ?? '';
    $artist_obj->church = $data->church ?? '';
    $artist_obj->password = password_hash($data->password, PASSWORD_DEFAULT);
    $artist_obj->rj_artist_pincode = $data->rj_artist_pincode ?? '';
    $artist_obj->rj_artist_landmark = $data->rj_artist_landmark ?? '';
    $artist_obj->reg_date = date('Y-m-d');
    
    // Check if phone number exists
    $phone = $artist_obj->phoneExists();
    if (!empty($phone)) {
      http_response_code(500);
      echo json_encode(array("status" => 0, "msg" => "Phone Number Already Exists"));
      exit();
    }
    
    // Check if Email exists
    $email_data = $artist_obj->check_email();
    if (!empty($email_data)) {
      
      http_response_code(500);
      echo json_encode(array(
        "status" => 0,
        "message" => "User already exists, try another email address"
      ));
    } else {
      if ($artist_obj->create_user()) {
        $result = EmailUtility::sendEmail(
        $data->email,
        'Registration Succesfull!',
          ' 
            <p> Welcome '.$data->name.'</p>
            <p>Thank you for registering with <strong>Rejoice Music</strong>.</p>
            <p>Your account has been successfully created and you are now part of our community.</p>
            <p>You can now log in and start using all the features we have to offer.</p>
          '
      );
        http_response_code(200);
        echo json_encode(array(
          "status" => 1,
          "message" => "User has been created"
        ));
      } else {
        http_response_code(500);
        echo json_encode(array(
          "status" => 0,
          "message" => "Failed to save user"
        ));
      }
    }
  } else {
    http_response_code(500);
    echo json_encode(array(
      "status" => 0,
      "message" => "All data needed"
    ));
  }
} else {
  http_response_code(503);
  echo json_encode(array(
    "status" => 0,
    "message" => "Access Denied"
  ));
}
