<?php

class User
{
  // define properties
  public $artist_id;
  public $name;
  public $email;
  public $phone;
  public $gender;
  public $country;
  public $state;
  public $city;
  public $church;
  public $district;
  public $pincode;
  public $add_date;
  public $add_time;
  public $otp;
  public $token;
  public $device_token;
  public $cus_id;
  public $song_id;
  public $cover;
  public $limit;
  public $offset;
  public $podcast_id;
  public $date;
  public $language_id;
  public $gener;
  public $notifi_id;
  public $pastor_name;
  public $church_name;
  public $church_pincode;
  public $church_state;
  public $church_city;
  public $church_district;
  public $order_id;
  public $cus_subscription_plan;
  public $amount;
  public $discount;
  public $paid_amount;
  public $validity;
  public $ex_date;
  public $exdate;
  public $coupon_code;
  public $final_sub_comision;
  public $gst;
  public $total_amount;
  public $payment_request_data;
  public $transaction_id;
  public $payment_response_data;
  public $promo_code;
  public $search;
  public $podcast_category;
  public $playtime;
  public $time;
  public $actual_time;
  public $commission;
  public $album_id;
  public $data;
  public $type;
  public $percentage;
  public $plan_amount;
  public $commission_amount;

  private $conn;
  private $users_tbl;

  public function __construct($db)
  {
    $this->conn = $db;
    $this->users_tbl = "rj_customer";
  }

  public function create_user()
  {

    $query = "INSERT INTO " . $this->users_tbl . " SET 
    artist_id = :artist_id,
    rj_cus_name = :name,
    rj_cus_email = :email,
    rj_cus_phone = :phone,
    rj_cus_gender = :gender,
    rj_cus_country = :country,
    rj_cus_state = :state,
    rj_cus_city = :city,
    rj_cus_church = :church,
    rj_district_id = :district,
    rj_cus_pincode = :pincode,
    rj_cus_add_date = :add_date,
    rj_cus_add_time = :add_time";

    $user_obj = $this->conn->prepare($query);

    $this->name = htmlspecialchars(strip_tags($this->name));
    $this->email = htmlspecialchars(strip_tags($this->email));
    $this->phone = htmlspecialchars(strip_tags($this->phone));
    $this->gender = htmlspecialchars(strip_tags($this->gender));
    $this->country = htmlspecialchars(strip_tags($this->country));
    $this->state = htmlspecialchars(strip_tags($this->state));
    $this->city = htmlspecialchars(strip_tags($this->city));
    $this->church = htmlspecialchars(strip_tags($this->church));
    $this->pincode = htmlspecialchars(strip_tags($this->pincode));
    $this->add_date = htmlspecialchars(strip_tags($this->add_date));
    $this->add_time = htmlspecialchars(strip_tags($this->add_time));
    $artist_id = json_encode($this->artist_id);

    $user_obj->bindParam(":artist_id", $artist_id);
    $user_obj->bindParam(":name", $this->name);
    $user_obj->bindParam(":email", $this->email);
    $user_obj->bindParam(":phone", $this->phone);
    $user_obj->bindParam(":gender", $this->gender);
    $user_obj->bindParam(":country", $this->country);
    $user_obj->bindParam(":state", $this->state);
    $user_obj->bindParam(":city", $this->city);
    $user_obj->bindParam(":district", $this->district);
    $user_obj->bindParam(":church", $this->church);
    $user_obj->bindParam(":pincode", $this->pincode);
    $user_obj->bindParam(":add_date", $this->add_date);
    $user_obj->bindParam(":add_time", $this->add_time);

    try {
      
      if ($user_obj->execute()) {
        $lastInsertedId = $this->conn->lastInsertId();
        return $lastInsertedId;
      }
    } catch (PDOException $e) {
      echo "Error: " . $e->getMessage();
      return false;
    }
  }


  public function check_email()
  {

    $email_query = "SELECT * from " . $this->users_tbl . " WHERE rj_cus_email = :email";

    $usr_obj = $this->conn->prepare($email_query);
    $usr_obj->bindParam(':email', $this->email);

    if ($usr_obj->execute()) {

      $data = $usr_obj->fetch(PDO::FETCH_ASSOC); // Fetch the result

      return $data;
    } else {
      die("Error in preparing the statement: " . $this->conn->error);
    }

    return array();
  }

  public function phoneExists()
  {

    $phone_query = "SELECT * from " . $this->users_tbl . " WHERE rj_cus_phone = :phone";

    $usr_obj = $this->conn->prepare($phone_query);
    $usr_obj->bindParam(':phone', $this->phone);

    if ($usr_obj->execute()) {

      $data = $usr_obj->fetch(PDO::FETCH_ASSOC); // Fetch the result

      return $data;
    } else {
      die("Error in preparing the statement: " . $this->conn->error);
    }

    return array();
  }

  public function check_login()
  {

    $email_query = "SELECT * from " . $this->users_tbl . " WHERE rj_cus_phone = :phone";

    $usr_obj = $this->conn->prepare($email_query);

    $usr_obj->bindParam(':phone', $this->phone);

    if ($usr_obj->execute()) {

      $data = $usr_obj->fetch(PDO::FETCH_ASSOC); // Fetch the result

      return $data;
    }

    return array();
  }

  public function updateOtp()
  {

    $email_query = "UPDATE " . $this->users_tbl . " SET
    rj_cus_otp = :otp
    WHERE rj_cus_phone = :phone";

    $usr_obj = $this->conn->prepare($email_query);
    $usr_obj->bindParam(':otp', $this->otp);
    $usr_obj->bindParam(':phone', $this->phone);

    if ($usr_obj->execute()) {

      $data = $usr_obj->fetch(PDO::FETCH_ASSOC); // Fetch the result

      return $data;
    }

    return array();
  }

  public function verifyOtp()
  {

    $email_query = "SELECT * from " . $this->users_tbl . " WHERE rj_cus_phone = :phone AND rj_cus_otp = :otp";

    $usr_obj = $this->conn->prepare($email_query);

    $usr_obj->bindParam(':phone', $this->phone);
    $usr_obj->bindParam(':otp', $this->otp);

    if ($usr_obj->execute()) {

      $data = $usr_obj->fetch(PDO::FETCH_ASSOC); // Fetch the result

      return $data;
    }

    return array();
  }

  public function tokenExists()
  {

    $phone_query = "SELECT * from " . $this->users_tbl . " WHERE rj_cus_token = :token";

    $usr_obj = $this->conn->prepare($phone_query);
    $usr_obj->bindParam(':token', $this->token);

    if ($usr_obj->execute()) {

      $data = $usr_obj->fetch(PDO::FETCH_ASSOC); // Fetch the result

      return $data;
    } else {
      die("Error in preparing the statement: " . $this->conn->error);
    }

    return array();
  }

  public function updateforPassword($phone, $new_password)
  {

    $query = "UPDATE " . $this->users_tbl . " 
              SET rj_artist_password = :new_password
              WHERE rj_cus_phone = :phone";
    $stmt = $this->conn->prepare($query);
    $stmt->bindParam(':new_password', $new_password);
    $stmt->bindParam(':phone', $phone);

    if ($stmt->execute()) {
      return ['status' => true, 'message' => 'Password updated successfully'];
    } else {
      return ['status' => false, 'message' => 'Password update failed'];
    }
  }

  public function generateAlphanumericCode($length = 8)
  {
    // Define the character pool
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomCode = '';

    // Generate the random code
    for ($i = 0; $i < $length; $i++) {
      $randomCode .= $characters[rand(0, $charactersLength - 1)];
    }

    return $randomCode;
  }

  public function ProfileDetail($user_id)
  {
    // Fetch rj_artist_church from the database to check if it is NULL

    $sqlQuery = "SELECT cus.*, sta.rj_state_name, dis.rj_district_name, ci.rj_city_name, con.rj_country_name, 'Others' AS rj_church_name
                     FROM `rj_customer` AS cus
                     LEFT JOIN rj_country AS con ON cus.rj_cus_country = con.rj_country_id
                     LEFT JOIN rj_state AS sta ON cus.rj_cus_state = sta.rj_state_id
                     LEFT JOIN rj_district AS dis ON cus.rj_cus_district = dis.rj_district_id
                     LEFT JOIN rj_city AS ci ON cus.rj_cus_city = ci.rj_city_id
                     WHERE cus.rj_cus_id = :user_id";

    // Prepare and execute the query
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);
    $stmt->execute();

    return $stmt;
  }

  public function getUserData($user_id)
  {
    $query = "SELECT * FROM " . $this->users_tbl . " WHERE rj_cus_id = :user_id";
    $stmt = $this->conn->prepare($query);
    $stmt->bindParam(":user_id", $user_id);
    $stmt->execute();

    return $stmt->fetch(PDO::FETCH_ASSOC);
  }

  public function addPlayList()
  {
    $sqlQuery = "INSERT INTO `rj_playlist` SET `rj_cus_id` = :cus_id, `rj_song_id` = :song";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->bindParam(':cus_id', $this->cus_id, PDO::PARAM_INT);
    $stmt->bindParam(':song', $this->song_id, PDO::PARAM_INT);
    $stmt->execute();
    return $stmt;
  }

  public function updateProfile()
  {
    $query = "UPDATE `rj_customer`
                  SET 
                  rj_cus_name = :name, 
                  rj_cus_email = :email, 
                  rj_cus_phone = :phone, 
                  rj_cus_gender = :gender,
                  rj_cus_country = :country,
                  rj_cus_state = :state,
                  rj_cus_city = :city,
                  rj_district_id = :district,
                  rj_cus_church = :church,
                  rj_cus_pincode = :pincode";
    $query .= " WHERE rj_cus_id = :cus_id";

    $user_obj = $this->conn->prepare($query);

    $user_obj->bindParam(":name", $this->name);
    $user_obj->bindParam(":email", $this->email);
    $user_obj->bindParam(":phone", $this->phone);
    $user_obj->bindParam(":gender", $this->gender);
    $user_obj->bindParam(":country", $this->country);
    $user_obj->bindParam(":state", $this->state);
    $user_obj->bindParam(":city", $this->city);
    $user_obj->bindParam(":church", $this->church);
    $user_obj->bindParam(":pincode", $this->pincode);
    $user_obj->bindParam(":cus_id", $this->cus_id);
    $user_obj->bindParam(":district", $this->district);


    // Execute the update
    if ($user_obj->execute()) {
      return true;
    } else {
      return false;
    }
  }


  public function UpdateProfilePic($user_id, $cover)
  {
    $query = "UPDATE rj_customer SET rj_cus_profile= :cover WHERE rj_cus_id = :user_id";
    $stmt = $this->conn->prepare($query);
    $stmt->bindParam(':cover', $cover);
    $stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);
    $stmt->execute();
    return $stmt;
  }


  public function Banner()
  {
    $sqlQuery = "SELECT * FROM `rj_banner` WHERE `rj_banner_type` = 'banner' AND `rj_banner_status` = 1 order by `rj_banner_id` DESC";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function podcastBanner()
  {
    $sqlQuery = "SELECT * FROM `rj_banner` WHERE `rj_banner_type` = 'podcast' AND `rj_banner_status` = 1 order by `rj_banner_id` DESC";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function Ads()
  {
    $sqlQuery = "SELECT * FROM `rj_banner` WHERE `rj_banner_type` != 'banner' AND `rj_banner_status` = 1 order by `rj_banner_id` DESC";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function NewAlbum()
  {
    $sqlQuery = "SELECT * FROM `rj_follower` JOIN rj_album ON rj_album.rj_artist_id = rj_follower.rj_artist_id WHERE rj_follower.rj_cus_id = '$this->cus_id' AND rj_album.rj_album_status = '1' ORDER BY rj_album.rj_album_date DESC LIMIT 0,10";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function TrendingSong()
  {
    $sqlQuery = "SELECT rj_song.*, COUNT(just_song_view_count.rj_cus_id) AS view_count
      FROM rj_song
      JOIN just_song_view_count ON rj_song.rj_song_id = just_song_view_count.rj_song_id
      WHERE rj_song.rj_song_status = '1'
      AND rj_song.rj_song_isDeleted = '0' 
      AND rj_song.approve_status = '1' -- Filter by song status
      -- AND just_song_view_count.rj_view_date >= DATE_SUB(CURDATE(), INTERVAL 1 DAY) -- Filter for the last 1 day
      GROUP BY rj_song.rj_song_id
      ORDER BY view_count DESC
      LIMIT 10;
      ";

    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function Artist()
  {
    $sqlQuery = "SELECT * FROM `rj_artist` WHERE `rj_artist_status` = '1' order by rj_artist_id DESC LIMIT 0,10";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function Gener()
  {
    $sqlQuery = "SELECT * FROM `rj_geners` order by rj_geners_id DESC LIMIT 0,10";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function Playlist()
  {
    $sqlQuery = "SELECT * 
    FROM rj_playlist 
    JOIN rj_song ON rj_song.rj_song_id = rj_playlist.rj_song_id 
    WHERE rj_playlist.rj_cus_id = :cus_id 
    AND rj_song.rj_song_status = '1' 
    AND rj_song.rj_song_isDeleted = '0' 
    AND rj_song.approve_status = '1'
    ORDER BY rj_playlist.rj_playlist_id DESC 
    LIMIT 0, 10";

    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->bindParam(':cus_id', $this->cus_id, PDO::PARAM_INT); // Bind the customer ID
    $stmt->execute();
    return $stmt;
  }

  public function Podcast()
  {
    $sqlQuery = "SELECT 
    a.rj_artist_id, 
    p.rj_podcast_id, 
    p.rj_podcast_title, 
    p.rj_podcast_status, 
    p.rj_podcast_live_status
FROM 
    rj_my_artist AS a
LEFT JOIN 
    rj_podcast AS p 
    ON p.rj_podcast_artist_id = a.rj_artist_id
WHERE 
    a.rj_cus_id = $this->cus_id
    AND p.rj_podcast_status = '1'
    AND p.rj_podcast_live_status = '2'
LIMIT 10";

    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function removePlayList()
  {
    $sqlQuery = "DELETE FROM `rj_playlist` WHERE `rj_cus_id` = :cus_id AND `rj_song_id` = :song_id";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->bindParam(':cus_id', $this->cus_id, PDO::PARAM_INT); // Bind the customer ID
    $stmt->bindParam(':song_id', $this->song_id, PDO::PARAM_INT); // Bind the Song ID

    $stmt->execute();
    return $stmt;
  }

  public function WorkshipPodcast()
  {
    $sqlQuery = "SELECT * FROM `rj_my_artist` 
    LEFT JOIN rj_podcast ON rj_podcast.rj_podcast_artist_id = rj_my_artist.rj_artist_id 
    WHERE rj_my_artist.rj_cus_id = $this->cus_id 
    AND rj_podcast.rj_podcast_status = '1' 
    AND rj_podcast.rj_podcast_live_status = '2' 
    AND rj_podcast.rj_podcast_category = '7' 
    LIMIT 0,10";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

public function popsong()
{
    $sqlQuery = "SELECT rj_song.*, COUNT(just_song_view_count.rj_cus_id) AS view_count
          FROM rj_song
          LEFT JOIN just_song_view_count  ON rj_song.rj_song_id = just_song_view_count.rj_song_id
          WHERE rj_song.rj_song_status = '1' 
          AND rj_song.rj_song_isDeleted = '0' 
          AND rj_song.approve_status = '1'
          -- AND YEAR(jvc.rj_view_date) = YEAR(CURDATE()) -- Filter by current year
          -- AND MONTH(jvc.rj_view_date) = MONTH(CURDATE()) -- Filter by current month
          GROUP BY rj_song.rj_song_id
          ORDER BY view_count DESC
          LIMIT 10;";

    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
}



  public function TopArtist()
  {
    // $sqlQuery = "SELECT * FROM `rj_artist` WHERE `rj_artist_status` = '1' order by RAND() LIMIT 0,10";
    // $sqlQuery = "SELECT rj_artist.*, COUNT(rj_follower.rj_artist_id) AS follower_count FROM rj_artist LEFT JOIN rj_follower ON rj_artist.rj_artist_id = rj_follower.rj_artist_id WHERE rj_artist.rj_artist_status = '1' GROUP BY rj_artist.rj_artist_id ORDER BY follower_count DESC LIMIT 10";
    
    $sqlQuery = "
        SELECT 
            rj_artist.*, 
            COUNT(just_song_view_count.just_song_view_id) AS total_views 
        FROM 
            rj_artist
        JOIN 
            rj_song ON rj_song.rj_artist_id = rj_artist.rj_artist_id
        JOIN 
            just_song_view_count ON just_song_view_count.rj_song_id = rj_song.rj_song_id
        WHERE 
            rj_artist.rj_artist_status = '1'
        GROUP BY 
            rj_artist.rj_artist_id
        ORDER BY 
            total_views DESC
        LIMIT 10
    ";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function FollowedArtist()
  {
    $sqlQuery = "SELECT * FROM `rj_follower` JOIN rj_artist ON rj_artist.rj_artist_id = rj_follower.rj_artist_id WHERE `rj_cus_id` = '$this->cus_id' group by rj_follower.rj_artist_id";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function allFollowedArtist()
  {
    // $sqlQuery = "SELECT *,  FROM `rj_follower` JOIN rj_artist ON rj_artist.rj_artist_id = rj_follower.rj_artist_id group by rj_follower.rj_artist_id";
    
      $sqlQuery = "
        SELECT 
            rj_artist.*, 
            COUNT(rj_follower.rj_artist_id) AS total_followers 
        FROM 
            rj_follower 
        JOIN 
            rj_artist ON rj_artist.rj_artist_id = rj_follower.rj_artist_id 
        GROUP BY 
            rj_follower.rj_artist_id 
        ORDER BY 
            total_followers DESC
    ";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }
  public function LikedSong()
  {
    $sqlQuery = "SELECT * FROM `rj_like_song` 
                                          JOIN rj_song ON rj_song.rj_song_id = rj_like_song.rj_like_song_id 
                                          WHERE rj_like_song.rj_cus_id = '$this->cus_id'  and rj_song.rj_song_status = '1' and rj_song.rj_song_isDeleted = '0' and rj_song.approve_status = '1' group by rj_like_song.rj_like_song_id";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function Downloadlist()
  {
    $sqlQuery = "SELECT * FROM `rj_song_download` 
                                          JOIN rj_song ON rj_song.rj_song_id = rj_song_download.rj_song_id 
                                          WHERE rj_song_download.rj_cus_id = '$this->cus_id' and rj_song.rj_song_status = '1' and rj_song.rj_song_isDeleted = '0' and rj_song.approve_status = '1' group by rj_song_download.rj_song_id";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function AllPlaylist()
  {
    $sqlQuery = "SELECT * FROM `rj_playlist` JOIN rj_song ON rj_song.rj_song_id = rj_playlist.rj_song_id WHERE rj_playlist.rj_cus_id = $this->cus_id and rj_song.rj_song_status = '1' and rj_song.rj_song_isDeleted = '0' and rj_song.approve_status = '1' order by rj_playlist.rj_playlist_id DESC";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function downloadPodcast()
  {
    $sqlQuery = "INSERT INTO `rj_podcast_download` SET `rj_cus_id` = :customer_id, `rj_podcast_id` = :podcast_id, `rj_download_date` = :date";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->bindParam(':customer_id', $this->cus_id, PDO::PARAM_INT); // Bind the customer ID
    $stmt->bindParam(':podcast_id', $this->podcast_id, PDO::PARAM_INT); // Bind the Song ID
    $stmt->bindParam(':date', $this->date, PDO::PARAM_INT); // Bind the Song ID
    $stmt->execute();
    return $stmt;
  }

  public function RemoveLanguage()
  {
    $sqlQuery = "DELETE FROM `rj_customer_language` WHERE `rj_language_id` = '$this->language_id' AND `rj_customer_id` = '$this->cus_id'";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function AddLanguage()
  {
    $sqlQuery = "INSERT INTO `rj_customer_language` SET `rj_language_id` = '$this->language_id', `rj_customer_id` = '$this->cus_id'";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function Followcheck()
  {
    $sqlQuery = "SELECT * FROM `rj_follower` WHERE `rj_cus_id` = '$this->cus_id' AND `rj_artist_id` = '$this->artist_id'";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function AddFollower()
  {
    $sqlQuery = "INSERT INTO `rj_follower` SET `rj_cus_id` = '$this->cus_id', `rj_artist_id` = '$this->artist_id', `rj_follow_date` = '$this->date'";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function RemoveFollower()
  {
    $sqlQuery = "DELETE FROM `rj_follower` WHERE `rj_cus_id` = '$this->cus_id' AND `rj_artist_id` = '$this->artist_id'";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function generSongList()
  {
    $sqlQuery = "SELECT * FROM `rj_song` WHERE `rj_song_genere` = :rj_geners_name and rj_song.rj_song_status = '1' and rj_song.rj_song_isDeleted = '0' and rj_song.approve_status = '1'";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->bindParam(':rj_geners_name', $this->gener);
    $stmt->execute();
    return $stmt;
  }

  public function LikeSong()
  {
    $sqlQuery = "INSERT INTO `rj_like_song` SET `rj_cus_id` = :cus_id, `rj_like_song_id` = :song_id, `rj_like_date` = :date";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->bindParam(':cus_id', $this->cus_id);
    $stmt->bindParam(':song_id', $this->song_id);
    $stmt->bindParam(':date', $this->date);
    $stmt->execute();
    return $stmt;
  }


  public function UnLikeSong()
  {
    $sqlQuery = "DELETE FROM `rj_like_song` WHERE `rj_cus_id` = :cus_id AND `rj_like_song_id` = :song_id";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->bindParam(':cus_id', $this->cus_id);
    $stmt->bindParam(':song_id', $this->song_id);
    $stmt->execute();
    return $stmt;
  }

  public function SelectArtistList()
  {
    $sqlQuery = "SELECT * FROM `rj_artist` WHERE rj_artist_status = '1'";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function DownloadSong()
  {
    $sqlQuery = "INSERT INTO `rj_song_download` SET `rj_cus_id` = '$this->cus_id', `rj_song_id` = '$this->song_id', `rj_song_download_date` = '$this->date'";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function ArtistFollower()
  {
    $sqlQuery = "SELECT * FROM `rj_follower` WHERE `rj_artist_id` = '$this->artist_id'";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }
  public function ArtistFollowed()
  {
    $sqlQuery = "SELECT * FROM `rj_follower` WHERE `rj_cus_id` = '$this->cus_id' AND `rj_artist_id` = '$this->artist_id'";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function ArtistSong()
  {
    $sqlQuery = "SELECT * FROM `rj_song` WHERE rj_artist_id = '$this->artist_id' and rj_song_status = '1' and rj_song_isDeleted = '0' and approve_status = '1'";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function ArtistAlbum()
  {
    $sqlQuery = "SELECT * FROM `rj_album` WHERE rj_artist_id = '$this->artist_id'";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function ArtistDetail()
  {
    $sqlQuery = "SELECT * FROM `rj_artist`  WHERE `rj_artist_id` = '$this->artist_id'";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function fetchnotification()
  {
    $sqlQuery = "
    SELECT b.* 
    FROM `rj_follower` AS a 
    JOIN `rj_notifications` AS b 
      ON a.`rj_artist_id` = b.`notify_art_id` 
    WHERE a.`rj_cus_id` = :cus_id 
    ORDER BY b.`notify_id` DESC 
    LIMIT :limit OFFSET :offset
";

    $stmt = $this->conn->prepare($sqlQuery);

    // Ensure parameters are sanitized
    $cus_id = intval($this->cus_id); // Ensure it's an integer
    $limit = intval($this->limit);   // Ensure it's an integer
    $offset = intval($this->offset); // Ensure it's an integer

    // Bind parameters
    $stmt->bindParam(':cus_id', $cus_id, PDO::PARAM_INT);
    $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);   // Use bindValue for non-variable limits
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT); // Use bindValue for non-variable offsets

    // Execute the query
    $stmt->execute();

    // Return the statement or fetch results as needed
    return $stmt;
  }

  public function totalnotification()
  {
    $sqlQuery = "SELECT b.* FROM `rj_follower` AS a JOIN `rj_notifications` AS b ON a.`rj_artist_id` = b.`notify_art_id` WHERE a.`rj_cus_id` = :cus_id";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->bindParam(':cus_id', $this->cus_id);

    $stmt->execute();
    return $stmt;
  }

  public function notifi_view_check()
  {
    $sqlQuery = "SELECT * FROM `notify_views` WHERE `user_id` = :cus_id AND `notify_id` = :notifi_id";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->bindParam(':cus_id', $this->cus_id);
    $stmt->bindParam(':notifi_id', $this->notifi_id);
    $stmt->execute();
    return $stmt;
  }

  public function notification_view()
  {
    $sqlQuery = "INSERT INTO `notify_views` SET `user_id` = '$this->cus_id', `notify_id` = '$this->notifi_id'";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function deleteNotify()
  {
    $sqlQuery = "DELETE FROM `notify_views` WHERE `user_id` = '$this->cus_id', `notify_id` = '$this->notifi_id'";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function notifiCount()
  {
    $sqlQuery = "SELECT COUNT(n.notify_id) AS unseen_count
      FROM rj_notifications n
      LEFT JOIN rj_follower follow ON follow.rj_artist_id = n.notify_art_id
      LEFT JOIN notify_views nv ON n.notify_id = nv.notify_id AND nv.user_id = :cus_id
      WHERE nv.notify_v_id IS NULL
        AND follow.rj_cus_id = :cus_id";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->bindParam(':cus_id', $this->cus_id);
    $stmt->execute();
    return $stmt;
  }

  function MyProfile()
  {
    // query to check if email exists
    $query = "SELECT * FROM " . $this->users_tbl . " WHERE rj_cus_id = '$this->cus_id' and `rj_cus_plan_ex_date` >= '$this->ex_date' LIMIT 0,1";
    // prepare the query
    $stmt = $this->conn->prepare($query);


    $stmt->execute();
    return $stmt;
  }


  function BuySubscription()
  {

    $query = "INSERT INTO `rj_buy_subscription`(`order_id`, `user_id`, `plan_id`, `amount`, `discount`, `paid_amount`, `validity`, `start_date`, `end_date`) VALUES ('$this->order_id','$this->cus_id','$this->cus_subscription_plan','$this->amount', '0', '$this->paid_amount', '$this->validity', '$this->ex_date', '$this->exdate')";
    // prepare the query
    $stmt = $this->conn->prepare($query);


    $stmt->execute();
    return $stmt;
  }

  function SubscriptionPlan()
  {
    // query to check if email exists
    $query = "SELECT * FROM rj_subscription WHERE rj_subscription_status = '1'";
    // prepare the query
    $stmt = $this->conn->prepare($query);


    $stmt->execute();
    return $stmt;
  }

  function MySubscriptionPlan()
  {
    // query to check if email exists
    $query = "SELECT * FROM rj_subscription WHERE rj_subscription_id = '$this->cus_subscription_plan'";
    // prepare the query
    $stmt = $this->conn->prepare($query);


    $stmt->execute();
    return $stmt;
  }

  function UnSubcribePlan()
  {
    $sqlQuery = "UPDATE " . $this->users_tbl . " SET `rj_cus_plan_ex_date` = '$this->ex_date', `rj_cus_subscription_plan` = '0' WHERE `rj_cus_id` = '$this->cus_id'";

    $stmt = $this->conn->prepare($sqlQuery);

    // $stmt->execute();
    // return $stmt;
    if ($stmt->execute()) {
      return true;
    } else {
      return false;
    }
  }

  function Couponcode()
  {

    $query = "SELECT * FROM rj_artist WHERE rj_artist_promocode = '$this->coupon_code' AND rj_artist_status != 0";
    // prepare the query
    $stmt = $this->conn->prepare($query);


    $stmt->execute();
    return $stmt;
  }

  function CouponcodeValid()
  {

    $query = "SELECT *
      FROM rj_artist
      INNER JOIN rj_promo_commision ON rj_artist.rj_artist_id = rj_promo_commision.rj_artist_id
      INNER JOIN rj_customer ON rj_promo_commision.rj_cus_id = rj_customer.rj_cus_id
      WHERE rj_artist.rj_artist_promocode = '$this->coupon_code'";
    // prepare the query
    $stmt = $this->conn->prepare($query);


    $stmt->execute();
    return $stmt;
  }

  function SubscriptionComission()
  {

    $query = "INSERT INTO `rj_promo_commision` SET `rj_artist_id` = '$this->artist_id',
                  `rj_cus_id` = '$this->cus_id',
                  `rj_prcommision` = '$this->final_sub_comision',
                  `rj_comis_dt` = '$this->date'";

    $stmt = $this->conn->prepare($query);


    $stmt->execute();
    return $stmt;
  }

  function SubscriptionComissionUpdate()
  {
    $date = date('Y-m-d');
    $sqlQuery = "UPDATE `rj_promo_commision` SET `rj_sub_status` = 1 WHERE `rj_cus_id` = '$this->cus_id' AND `rj_comis_dt` = '$date'";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

 
  function transactionLogs()
  {

    $query = "INSERT INTO `transaction_logs` SET `user_id` = '$this->cus_id',
                  `paid_amount` = '$this->paid_amount',
                  `plan_id` = '$this->cus_subscription_plan',
                  `promo_code` = '$this->promo_code',
                  `gst` = '$this->gst',
                  `total_amount` = '$this->total_amount',
                  `order_id` = '$this->order_id',
                  `payment_request_data` = '$this->payment_request_data'";

    $stmt = $this->conn->prepare($query);


    $stmt->execute();
    return $stmt;
  }

  function UpdateTransactionLogs()
  {
    $sqlQuery = "UPDATE `transaction_logs` SET `transaction_id` = '$this->transaction_id', `payment_response_data`='$this->payment_response_data', `status` = 'paid' WHERE `order_id` = '$this->order_id'";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function Search()
  {
    $sqlQuery = "SELECT * 
      FROM `rj_song` 
      WHERE `rj_song_status` = '1' 
      AND `rj_song_title` LIKE '%$this->search%' 
      AND `rj_song_title` <> ''
      AND `rj_song_title` IS NOT NULL 
      AND `rj_song_isDeleted` = '0'
      ORDER BY `rj_song_title` ASC 
      LIMIT 0,5;
      ";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function SearchAlbum()
  {
    $sqlQuery = "SELECT * FROM `rj_album` where `rj_ablum_title` LIKE '%$this->search%' LIMIT 0,5";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function SearchArtist()
  {
    $sqlQuery = "SELECT * FROM `rj_artist` WHERE `rj_artist_status` = '1' AND `rj_artist_name` LIKE '%$this->search%' LIMIT 0,5";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function RecentPodcasts()
  {
    $sqlQuery = "SELECT * FROM `rj_podcast` 
    JOIN rj_podcast_category 
    ON rj_podcast_category.rj_podcast_category_id = rj_podcast.rj_podcast_category 
    WHERE rj_podcast.rj_podcast_status = '1' 
    AND rj_podcast.rj_podcast_live_status = '2' 
    AND rj_podcast.rj_podcast_IsDeleted = 0 
    ORDER BY rj_podcast.rj_podcast_id DESC 
    LIMIT 0,5";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function livePodcast()
  {
    $sqlQuery = "SELECT * FROM `rj_podcast` 
    JOIN rj_podcast_category 
    ON rj_podcast_category.rj_podcast_category_id = rj_podcast.rj_podcast_category 
    WHERE rj_podcast.rj_podcast_status = '1' 
    AND rj_podcast.rj_podcast_live_status = '2'
    AND rj_podcast.rj_podcast_IsDeleted = '0'
    ORDER BY rj_podcast.rj_podcast_date ASC 
    LIMIT 0,1";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function UpcomingPodcast()
  {
    $sqlQuery = "SELECT * FROM `rj_podcast` 
    JOIN rj_podcast_category 
    ON rj_podcast_category.rj_podcast_category_id = rj_podcast.rj_podcast_category 
    WHERE rj_podcast.rj_podcast_status = '1' 
    AND rj_podcast.rj_podcast_IsDeleted = '0' 
    AND rj_podcast.rj_podcast_live_status != '3' 
    AND rj_podcast.rj_podcast_date > NOW() 
    ORDER BY rj_podcast.rj_podcast_date ASC 
    LIMIT 0,10";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }


  public function MyPodCat()
  {
    $sqlQuery = "SELECT * FROM `rj_podcast` JOIN rj_podcast_category ON rj_podcast_category.rj_podcast_category_id = rj_podcast.rj_podcast_category where rj_podcast.rj_podcast_live_status = 3 and rj_podcast.rj_podcast_IsDeleted = '0' group by rj_podcast.rj_podcast_category order by rj_podcast.rj_podcast_date ASC";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function MyPodcast()
  {
    $sqlQuery = "
    SELECT * 
    FROM `rj_podcast` 
    WHERE 
        `rj_podcast_live_status` = :live_status 
        AND `rj_podcast_IsDeleted` = :is_deleted 
        AND `rj_podcast_category` = :podcast_category 
    ORDER BY `rj_podcast_date` ASC
";

    $stmt = $this->conn->prepare($sqlQuery);

    // Bind parameters securely
    $liveStatus = 3; // Hardcoded value
    $isDeleted = '0'; // Hardcoded value
    $podcastCategory = $this->podcast_category;

    $stmt->bindParam(':live_status', $liveStatus, PDO::PARAM_INT);
    $stmt->bindParam(':is_deleted', $isDeleted, PDO::PARAM_STR);
    $stmt->bindParam(':podcast_category', $podcastCategory, PDO::PARAM_STR);

    // Execute the query
    $stmt->execute();

    return $stmt;
  }

  
  public function updateDeviceToken()
  {
    $email_query = "UPDATE `rj_customer` SET device_token = :device_token  WHERE rj_cus_id = :cus_id";

    $usr_obj = $this->conn->prepare($email_query);

    $usr_obj->bindParam(':cus_id', $this->cus_id);
    $usr_obj->bindParam(':device_token', $this->device_token);

    if ($usr_obj->execute()) {

      $data = $usr_obj->fetch(PDO::FETCH_ASSOC); // Fetch the result

      return $data;
    }

    return array();
  }

  
  public function getUserTimeCount(){
    $query = "SELECT SUM(play_time) as total FROM rj_song_playtime WHERE rj_cus_id = :cus_id AND rj_view_date = :date";
    $stmt = $this->conn->prepare($query);
    $stmt->bindParam(':cus_id', $this->cus_id);
    $stmt->bindParam(':date', $this->date);
    $stmt->execute();
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    return $row;
  }

  public function AddViewPlayssSong()
  {
      $sqlQuery = "INSERT INTO `rj_song_playtime` SET `rj_cus_id` = '$this->cus_id',`rj_song_id` = '$this->song_id',`rj_artist_id` = '$this->artist_id',`rj_album_id` = '$this->album_id',`rj_view_date` = '$this->date',`rj_view_time` = '$this->time', `timeing`='$this->playtime', `play_time`='$this->actual_time'";
      $stmt = $this->conn->prepare($sqlQuery);
      $stmt->execute();
      return $stmt;
  }
  public function addArtistRoyalty(){
    $sqlQuery = "INSERT INTO `rj_song_commision` SET `rj_artist_id` = '$this->artist_id',`song_id` = '$this->song_id',`rj_commision` = '$this->commission',`rj_comis_dt` = '$this->date'";
      $stmt = $this->conn->prepare($sqlQuery);
      $stmt->execute();
      return $stmt;
  }

  
  public function addData(){
    $sqlQuery = "INSERT INTO `transactiondata` SET `data` = '$this->data'";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function getTransactionData(){
    $sqlQuery = "SELECT * FROM `transaction_logs` WHERE `order_id` = '$this->order_id'";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }

  public function artistCommissionLog()
  {

      $query = "INSERT INTO `rj_artist_commission_log` SET 
                  `artist_id` = '$this->artist_id',
                  `commission_type` = '$this->type',
                  `user_id` = '$this->cus_id',
                  `transaction_amount` = '$this->paid_amount',
                  `subscription_plan_amount` = '$this->plan_amount',
                  `commission_percentage` = '$this->percentage',
                  `commission_amount` = '$this->commission_amount'";

      $stmt = $this->conn->prepare($query);
      $stmt->execute();
      return $stmt;
  }

  public function Userupdatesub()
  {
      $sqlQuery = "UPDATE `rj_customer` SET `artist_id` = '$this->artist_id', `rj_subscription_start_date` = '$this->ex_date', `rj_cus_plan_ex_date` = '$this->exdate',`rj_cus_subscription_plan` = '$this->cus_subscription_plan',`coupon_code` = '$this->coupon_code' WHERE `rj_cus_id` = '$this->cus_id'";
      $stmt = $this->conn->prepare($sqlQuery);
      $stmt->execute();
      return $stmt;
  }

}
