<?php

class Artist
{
  // define properties
  public $name;
  public $email;
  public $limit;
  public $offset;
  public $phone;
  public $gender;
  public $dob;
  public $address;
  public $country;
  public $state;
  public $district;
  public $city;
  public $church;
  public $password;
  public $rj_artist_pincode;
  public $rj_artist_landmark;
  public $reg_date;
  public $otp;
  public $cover;
  public $token;
  public $device_token;
  public $artist_id;
  public $promocode;

  private $conn;
  private $users_tbl;

  public function __construct($db)
  {
    $this->conn = $db;
    $this->users_tbl = "rj_artist";
  }

  public function create_user()
  {

    $query = "INSERT INTO " . $this->users_tbl . " SET 
    rj_artist_name = :name,
    rj_artist_email = :email,
    rj_artist_phone = :phone,
    rj_artist_gender = :gender,
    rj_artist_dob = :dob,
    rj_artist_address = :address,
    rj_artist_country = :country,
    rj_artist_state = :state,
    rj_artist_city = :city,
    rj_artist_district = :district,
    rj_artist_church = :church,
    rj_artist_date = :reg_date,
    rj_artist_pincode = :rj_artist_pincode,
    rj_artist_landmark = :rj_artist_landmark,
    rj_artist_password = :password";

    $artist_obj = $this->conn->prepare($query);

    $this->name = htmlspecialchars(strip_tags($this->name));
    $this->email = htmlspecialchars(strip_tags($this->email));
    $this->phone = htmlspecialchars(strip_tags($this->phone));
    $this->gender = htmlspecialchars(strip_tags($this->gender));
    $this->dob = !empty($this->dob) ? htmlspecialchars(strip_tags($this->dob)) : null;
    $this->address = htmlspecialchars(strip_tags($this->address));
    $this->country = htmlspecialchars(strip_tags($this->country));
    $this->state = htmlspecialchars(strip_tags($this->state));
    $this->city = htmlspecialchars(strip_tags($this->city));
    $this->district = htmlspecialchars(strip_tags($this->district));
    $this->church = htmlspecialchars(strip_tags($this->church));
    $this->password = htmlspecialchars(strip_tags($this->password));
    $this->reg_date = htmlspecialchars(strip_tags($this->reg_date));
    // $this->unique_id = htmlspecialchars(strip_tags($this->unique_id));
    $this->rj_artist_pincode = htmlspecialchars(strip_tags($this->rj_artist_pincode));
    $this->rj_artist_landmark = htmlspecialchars(strip_tags($this->rj_artist_landmark));

    $artist_obj->bindParam(":name", $this->name);
    $artist_obj->bindParam(":email", $this->email);
    $artist_obj->bindParam(":phone", $this->phone);
    $artist_obj->bindParam(":gender", $this->gender);
    $artist_obj->bindParam(":dob", $this->dob);
    $artist_obj->bindParam(":address", $this->address);
    $artist_obj->bindParam(":country", $this->country);
    $artist_obj->bindParam(":state", $this->state);
    $artist_obj->bindParam(":city", $this->city);
    $artist_obj->bindParam(":district", $this->district);
    $artist_obj->bindParam(":church", $this->church);
    $artist_obj->bindParam(":password", $this->password);
    $artist_obj->bindParam(":reg_date", $this->reg_date);
    $artist_obj->bindParam(":rj_artist_pincode", $this->rj_artist_pincode);
    $artist_obj->bindParam(":rj_artist_landmark", $this->rj_artist_landmark);

    try {
      if ($artist_obj->execute()) {
        return true;
      }
    } catch (PDOException $e) {
      echo "Error: " . $e->getMessage();
      return false;
    }
  }

  public function check_email()
  {

    $email_query = "SELECT * from " . $this->users_tbl . " WHERE rj_artist_email = :email";

    $usr_obj = $this->conn->prepare($email_query);
    $usr_obj->bindParam(':email', $this->email);

    if ($usr_obj->execute()) {

      $data = $usr_obj->fetch(PDO::FETCH_ASSOC); // Fetch the result

      return $data;
    } else {
      die("Error in preparing the statement: " . $this->conn->error);
    }

    return array();
  }

  public function phoneExists()
  {

    $phone_query = "SELECT * from " . $this->users_tbl . " WHERE rj_artist_phone = :phone";

    $usr_obj = $this->conn->prepare($phone_query);
    $usr_obj->bindParam(':phone', $this->phone);

    if ($usr_obj->execute()) {

      $data = $usr_obj->fetch(PDO::FETCH_ASSOC); // Fetch the result

      return $data;
    } else {
      die("Error in preparing the statement: " . $this->conn->error);
    }

    return array();
  }

  public function tokenExists()
  {

    $phone_query = "SELECT * from " . $this->users_tbl . " WHERE rj_artist_token = :token";

    $usr_obj = $this->conn->prepare($phone_query);
    $usr_obj->bindParam(':token', $this->token);

    if ($usr_obj->execute()) {

      $data = $usr_obj->fetch(PDO::FETCH_ASSOC); // Fetch the result

      return $data;
    } else {
      die("Error in preparing the statement: " . $this->conn->error);
    }

    return array();
  }

  public function check_login()
  {

    $email_query = "SELECT * from " . $this->users_tbl . " WHERE rj_artist_phone = :phone";

    $usr_obj = $this->conn->prepare($email_query);

    $usr_obj->bindParam(':phone', $this->phone);

    if ($usr_obj->execute()) {

      $data = $usr_obj->fetch(PDO::FETCH_ASSOC); // Fetch the result

      return $data;
    }

    return array();
  }

  public function updateOtp()
  {

    $email_query = "UPDATE " . $this->users_tbl . " SET rj_artist_otp = :otp  WHERE rj_artist_phone = :phone";

    $usr_obj = $this->conn->prepare($email_query);

    $usr_obj->bindParam(':phone', $this->phone);
    $usr_obj->bindParam(':otp', $this->otp);

    if ($usr_obj->execute()) {

      $data = $usr_obj->fetch(PDO::FETCH_ASSOC); // Fetch the result

      return $data;
    }

    return array();
  }

  public function updateToken()
  {

    $email_query = "UPDATE " . $this->users_tbl . " SET rj_artist_token = :token  WHERE rj_artist_phone = :phone";

    $usr_obj = $this->conn->prepare($email_query);

    $usr_obj->bindParam(':phone', $this->phone);
    $usr_obj->bindParam(':token', $this->token);

    if ($usr_obj->execute()) {

      $data = $usr_obj->fetch(PDO::FETCH_ASSOC); // Fetch the result

      return $data;
    }

    return array();
  }

  public function updateDeviceToken()
  {
    $email_query = "UPDATE " . $this->users_tbl . " SET device_token = :device_token  WHERE rj_artist_id = :artist_id";

    $usr_obj = $this->conn->prepare($email_query);

    $usr_obj->bindParam(':artist_id', $this->artist_id);
    $usr_obj->bindParam(':device_token', $this->device_token);

    if ($usr_obj->execute()) {

      $data = $usr_obj->fetch(PDO::FETCH_ASSOC); // Fetch the result

      return $data;
    }

    return array();
  }

  public function verifyOtp()
  {

    $email_query = "SELECT * from " . $this->users_tbl . " WHERE rj_artist_phone = :phone AND rj_artist_otp = :otp";

    $usr_obj = $this->conn->prepare($email_query);

    $usr_obj->bindParam(':phone', $this->phone);
    $usr_obj->bindParam(':otp', $this->otp);

    if ($usr_obj->execute()) {

      $data = $usr_obj->fetch(PDO::FETCH_ASSOC); // Fetch the result

      return $data;
    }

    return array();
  }

  public function updateforPassword($phone, $new_password)
  {

    $query = "UPDATE " . $this->users_tbl . " 
              SET rj_artist_password = :new_password
              WHERE rj_artist_phone = :phone";
    $stmt = $this->conn->prepare($query);
    $stmt->bindParam(':new_password', $new_password);
    $stmt->bindParam(':phone', $phone);

    if ($stmt->execute()) {
      return ['status' => true, 'message' => 'Password updated successfully'];
    } else {
      return ['status' => false, 'message' => 'Password update failed'];
    }
  }

  public function generateAlphanumericCode($length = 8)
  {
    // Define the character pool
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomCode = '';

    // Generate the random code
    for ($i = 0; $i < $length; $i++) {
      $randomCode .= $characters[rand(0, $charactersLength - 1)];
    }

    return $randomCode;
  }

  public function getUserData($artist_id)
  {
    $query = "SELECT rj_artist_id, rj_artist_name, rj_artist_email, rj_artist_phone, rj_artist_gender, rj_artist_song_commision, rj_artist_subscription_commision FROM " . $this->users_tbl . " WHERE rj_artist_id = :rj_artist_id";
    $stmt = $this->conn->prepare($query);
    $stmt->bindParam(":rj_artist_id", $artist_id);
    $stmt->execute();

    return $stmt->fetch(PDO::FETCH_ASSOC);
  }

  public function updateProfile()
  {
    $query = "UPDATE " . $this->users_tbl . "
              SET rj_artist_name = :rj_artist_name, 
              rj_artist_email = :rj_artist_email,
              rj_artist_phone = :rj_artist_phone, 
              rj_artist_gender = :rj_artist_gender,
              rj_artist_dob = :dob,
              rj_artist_address = :address,
              rj_artist_country = :country,
              rj_artist_state = :state,
              rj_artist_city = :city,
              rj_artist_district = :district,
              rj_artist_church = :church,
              rj_artist_pincode = :rj_artist_pincode,
              rj_artist_landmark = :rj_artist_landmark
              WHERE rj_artist_id = :rj_artist_id";

    $stmt = $this->conn->prepare($query);

    // Bind parameters
    $stmt->bindParam(":rj_artist_id", $this->artist_id);
    $stmt->bindParam(":rj_artist_name", $this->name);
    $stmt->bindParam(":rj_artist_email", $this->email);
    $stmt->bindParam(":rj_artist_phone", $this->phone);
    $stmt->bindParam(":rj_artist_gender", $this->gender);
    $stmt->bindParam(":dob", $this->dob);
    $stmt->bindParam(":address", $this->address);
    $stmt->bindParam(":country", $this->country);
    $stmt->bindParam(":state", $this->state);
    $stmt->bindParam(":city", $this->city);
    $stmt->bindParam(":district", $this->district);
    $stmt->bindParam(":church", $this->church);
    $stmt->bindParam(":rj_artist_pincode", $this->rj_artist_pincode);
    $stmt->bindParam(":rj_artist_landmark", $this->rj_artist_landmark);

    // Execute the update
    if ($stmt->execute()) {
      return true;
    } else {
      return false;
    }
  }


  public function ProfileDetail($artist_id)
  {

    // Fetch rj_artist_church from the database to check if it is NULL
    $churchCheckQuery = "SELECT rj_artist_church FROM " . $this->users_tbl . " WHERE rj_artist_id = :artist_id";
    $churchStmt = $this->conn->prepare($churchCheckQuery);
    $churchStmt->bindParam(':artist_id', $artist_id, PDO::PARAM_INT);
    $churchStmt->execute();

    // Get the result
    $result = $churchStmt->fetch(PDO::FETCH_ASSOC);
    // $rj_artist_church = $result['rj_artist_church'];

    // Build the query based on the value of rj_artist_church
    // if (!empty($rj_artist_church)) {
    $sqlQuery = "SELECT cus.*, sta.rj_state_name, dis.rj_district_name, ci.rj_city_name, chu.rj_church_name, con.rj_country_name FROM 
      `rj_artist` AS cus 
      LEFT JOIN rj_country AS con ON cus.rj_artist_country = con.rj_country_id 
      LEFT JOIN rj_state AS sta ON cus.rj_artist_state = sta.rj_state_id 
      LEFT JOIN rj_district AS dis ON cus.rj_artist_district = dis.rj_district_id 
      LEFT JOIN rj_city AS ci ON cus.rj_artist_city = ci.rj_city_id 
      LEFT JOIN rj_church AS chu ON cus.rj_artist_church = chu.rj_church_id 
      WHERE cus.rj_artist_id = :artist_id";
    // } else {
    // $sqlQuery = "SELECT cus.*, sta.rj_state_name, dis.rj_district_name, ci.rj_city_name, con.rj_country_name, 'Others' AS rj_church_name
    //                FROM `rj_artist` AS cus
    //                LEFT JOIN rj_country AS con ON cus.rj_artist_country = con.rj_country_id
    //                LEFT JOIN rj_state AS sta ON cus.rj_artist_state = sta.rj_state_id
    //                LEFT JOIN rj_district AS dis ON cus.rj_artist_district = dis.rj_district_id
    //                LEFT JOIN rj_city AS ci ON cus.rj_artist_city = ci.rj_city_id
    //                WHERE cus.rj_artist_id = :artist_id";
    // }

    // Prepare and execute the query
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->bindParam(':artist_id', $artist_id, PDO::PARAM_INT);
    $stmt->execute();

    return $stmt->fetch(PDO::FETCH_ASSOC);
  }

  public function UpdateProfilePic($artist_id)
  {
    $query = "UPDATE " . $this->users_tbl . " SET `rj_artist_profile` = '$this->cover' WHERE rj_artist_id = :artist_id";
    $stmt = $this->conn->prepare($query);
    $stmt->bindParam(':artist_id', $artist_id, PDO::PARAM_INT);
    $stmt->execute();
    return $stmt;
  }

  public function getArtist()
  {
    $query = "SELECT * FROM  rj_artist WHERE rj_artist_status = 1 AND approve_status = 1";
    $stmt = $this->conn->prepare($query);
    $stmt->execute();
    return $stmt;
  }

  public function PromoCount()
  {
    $query = "SELECT * FROM rj_artist_commission_log WHERE artist_id = '$this->artist_id' AND commission_type = 0";
    $stmt = $this->conn->prepare($query);

    $stmt->execute();
    return $stmt;
  }


  public function PromoAmount()
  {
    $query = "SELECT a.artist_id,
                                     b.rj_artist_name,
                                     COUNT(a.user_id) AS total_views,
                                     SUM(a.commission_amount) AS total_commission
                                 FROM
                                     rj_artist_commission_log AS a
                                 LEFT JOIN
                                     rj_artist AS b ON a.artist_id = b.rj_artist_id
                                 WHERE
                                     a.commission_type = 0 AND b.rj_artist_id = '$this->artist_id'";
    $stmt = $this->conn->prepare($query);

    $stmt->execute();
    return $stmt;
  }

 public function getPromoCommision()
{
    $query = "SELECT 
                ac.*, 
                u.rj_cus_name AS user_name
              FROM 
                rj_artist_commission_log AS ac
              JOIN 
                rj_customer AS u ON ac.user_id = u.rj_cus_id
              WHERE 
                ac.commission_type = 0 AND ac.artist_id = :artist_id";

    $stmt = $this->conn->prepare($query);
    $stmt->bindParam(':artist_id', $this->artist_id);
    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}


  public function TotalPlayTime()
  {
    $query = "SELECT SUM(timeing) as totaltime FROM `rj_song_playtime` WHERE rj_artist_id = '$this->artist_id'";
    $stmt = $this->conn->prepare($query);

    $stmt->execute();
    return $stmt;
  }

  public function SongCommission()
  {
    $query = "SELECT a.rj_com_id,
                         a.rj_artist_id,
                         b.rj_artist_name,
                         a.rj_song_views AS total_views,
                         SUM(a.rj_commision) AS total_commission
                     FROM
                         rj_song_commision AS a
                     JOIN rj_artist AS b ON a.rj_artist_id = b.rj_artist_id WHERE a.rj_artist_id = '$this->artist_id'";
    $stmt = $this->conn->prepare($query);

    $stmt->execute();
    return $stmt;
  }

  public function getArtistSongCommision()
  {
    $query = "SELECT 
                s.rj_song_title AS rj_song_title,
                DATE(se.rj_comis_dt) AS date,
                SUM(se.rj_commision) AS total_earnings
            FROM 
                rj_song_commision AS se
            JOIN 
                rj_song AS s ON se.song_id = s.rj_song_id
            WHERE 
                se.rj_artist_id = :artist_id
            GROUP BY 
                s.rj_song_title, DATE(se.rj_comis_dt)
            ORDER BY 
                DATE(se.rj_comis_dt), s.rj_song_title";

    $stmt = $this->conn->prepare($query);
    $stmt->bindParam(':artist_id', $this->artist_id);
    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
  }


  public function Notification()
  {
    $sqlQuery = "SELECT * FROM `rj_artist_notification` WHERE `rj_artist_notification_artist_id` IN ('0', '$this->artist_id') order by rj_artist_notification_id DESC LIMIT :limit OFFSET :offset";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->bindParam(':limit', $this->limit, PDO::PARAM_INT);
    $stmt->bindParam(':offset', $this->offset, PDO::PARAM_INT);
    $stmt->execute();
    return $stmt;
  }
  public function totalNotifications()
  {
    $sqlQuery = "SELECT * FROM `rj_artist_notification` WHERE `rj_artist_notification_artist_id` IN ('0', '$this->artist_id') order by rj_artist_notification_id DESC";
    $stmt = $this->conn->prepare($sqlQuery);
    $stmt->execute();
    return $stmt;
  }
  public function updateemailOtp()
  {

    $query = "INSERT INTO email_verify SET 
    email = :email,
    otp= :otp";

    $usr_obj = $this->conn->prepare($query);

    $usr_obj->bindParam(':email', $this->email);
    $usr_obj->bindParam(':otp', $this->otp);

    return $usr_obj->execute();
  }

  public function check_otp_email()
  {

     $email_query = "SELECT * FROM email_verify WHERE email = :email ORDER BY id DESC LIMIT 1";

    $usr_obj = $this->conn->prepare($email_query);
    $usr_obj->bindParam(':email', $this->email);

    if ($usr_obj->execute()) {
        return $usr_obj->fetch(PDO::FETCH_ASSOC);
    } else {
        die("Error in preparing the statement: " . $this->conn->error);
    }
    return array();
  }

public function check_promocode()
{
    $query = "SELECT * 
              FROM rj_artist 
              WHERE rj_artist_promocode = :promocode";

    $stmt = $this->conn->prepare($query);
    $stmt->bindParam(':promocode', $this->promocode, PDO::PARAM_STR);
    $stmt->execute();

    // return one row
    return $stmt->fetch(PDO::FETCH_ASSOC);
}
}
