<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
// include vendor
require '../../vendor/autoload.php';
use \Firebase\JWT\JWT;

//include headers
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Content-type: application/json; charset=utf-8");

// including files
include_once("../../config/Database.php");
include_once("../../models/Artist.php");
include_once("../../models/Content.php");
include_once("../../models/User.php");
include_once("../../models/Album.php");
include_once("../../models/Song.php");
include_once("../../models/Podcast.php");
require_once ('../../common/EmailUtility.php');




// db objects
$db = new Database();
$connection = $db->connect();

// initialization of model objects
$artist_obj = new Artist($connection);
$content_obj = new Content($connection);
$user_obj = new User($connection);
$song_obj = new Song($connection);
$album_obj = new Album($connection);
$podcast_obj = new Podcast($connection);
