<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Testing;

class ApkSplits extends \Google\Collection
{
  protected $collection_key = 'bundleSplits';
  protected $bundleSplitsType = FileReference::class;
  protected $bundleSplitsDataType = 'array';

  /**
   * A list of .apk files generated by bundletool to install to the device under
   * test as a single android app with adb install-multiple. If specified,
   * requires one or more bundle_splits. The first split specified represents
   * the base APK, while subsequent splits represent feature apks.
   *
   * @param FileReference[] $bundleSplits
   */
  public function setBundleSplits($bundleSplits)
  {
    $this->bundleSplits = $bundleSplits;
  }
  /**
   * @return FileReference[]
   */
  public function getBundleSplits()
  {
    return $this->bundleSplits;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ApkSplits::class, 'Google_Service_Testing_ApkSplits');
