<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\BigQueryConnectionService;

class CloudSqlProperties extends \Google\Model
{
  /**
   * Unspecified database type.
   */
  public const TYPE_DATABASE_TYPE_UNSPECIFIED = 'DATABASE_TYPE_UNSPECIFIED';
  /**
   * Cloud SQL for PostgreSQL.
   */
  public const TYPE_POSTGRES = 'POSTGRES';
  /**
   * Cloud SQL for MySQL.
   */
  public const TYPE_MYSQL = 'MYSQL';
  protected $credentialType = CloudSqlCredential::class;
  protected $credentialDataType = '';
  /**
   * Database name.
   *
   * @var string
   */
  public $database;
  /**
   * Cloud SQL instance ID in the form `project:location:instance`.
   *
   * @var string
   */
  public $instanceId;
  /**
   * Output only. The account ID of the service used for the purpose of this
   * connection. When the connection is used in the context of an operation in
   * BigQuery, this service account will serve as the identity being used for
   * connecting to the CloudSQL instance specified in this connection.
   *
   * @var string
   */
  public $serviceAccountId;
  /**
   * Type of the Cloud SQL database.
   *
   * @var string
   */
  public $type;

  /**
   * Input only. Cloud SQL credential.
   *
   * @param CloudSqlCredential $credential
   */
  public function setCredential(CloudSqlCredential $credential)
  {
    $this->credential = $credential;
  }
  /**
   * @return CloudSqlCredential
   */
  public function getCredential()
  {
    return $this->credential;
  }
  /**
   * Database name.
   *
   * @param string $database
   */
  public function setDatabase($database)
  {
    $this->database = $database;
  }
  /**
   * @return string
   */
  public function getDatabase()
  {
    return $this->database;
  }
  /**
   * Cloud SQL instance ID in the form `project:location:instance`.
   *
   * @param string $instanceId
   */
  public function setInstanceId($instanceId)
  {
    $this->instanceId = $instanceId;
  }
  /**
   * @return string
   */
  public function getInstanceId()
  {
    return $this->instanceId;
  }
  /**
   * Output only. The account ID of the service used for the purpose of this
   * connection. When the connection is used in the context of an operation in
   * BigQuery, this service account will serve as the identity being used for
   * connecting to the CloudSQL instance specified in this connection.
   *
   * @param string $serviceAccountId
   */
  public function setServiceAccountId($serviceAccountId)
  {
    $this->serviceAccountId = $serviceAccountId;
  }
  /**
   * @return string
   */
  public function getServiceAccountId()
  {
    return $this->serviceAccountId;
  }
  /**
   * Type of the Cloud SQL database.
   *
   * Accepted values: DATABASE_TYPE_UNSPECIFIED, POSTGRES, MYSQL
   *
   * @param self::TYPE_* $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return self::TYPE_*
   */
  public function getType()
  {
    return $this->type;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(CloudSqlProperties::class, 'Google_Service_BigQueryConnectionService_CloudSqlProperties');
