<?php
//inlcude headers
require_once('../../common/header.php');
require_once('../../common/request.php');


$data = json_decode(file_get_contents("php://input"));


$payment = $data->payload->payment->entity;
if ($payment->status == 'authorized' || $payment->status == 'captured') {
    $transaction_id = $payment->id;
    $order_id = $payment->order_id;
    $payment_response_data = json_encode($data);
    $user_obj->order_id = $order_id;
    $transactionData = $user_obj->getTransactionData();
    $itemCount = $transactionData->rowCount();
    $plan_id = 0;
    $plan_amount = '';
    $promo_code = '';
    $validity = '';
    $user_id = '';
    if ($itemCount > 0) {
        while ($row = $transactionData->fetch(PDO::FETCH_ASSOC)) {
            $plan_id = $row['plan_id'];
            $promo_code = $row['promo_code'];
            $user_id = $row['user_id'];
        }
    }
    $transactionData = $transactionData->fetch(PDO::FETCH_ASSOC);
    $user_obj->cus_subscription_plan = $plan_id;
    $user_obj->cus_id = $user_id;



    // Get Subscription plan data
    $stmt = $user_obj->MySubscriptionPlan();
    $itemCount = $stmt->rowCount();
    if ($itemCount > 0) {
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $plan_id = $row['rj_subscription_id'];
            $plan_name = $row['rj_subscription_title'];
            $plan_amount = $row['rj_subscription_plan'];
            $paid_amount = $row['rj_subscription_plan'];
            $validity = $row['rj_subscription_validity'];
        }
    } else {
        $plan_amount = 0;
        $validity = 0;
    }

    // Get artist commission details
    $user_obj->artist_id = null;
    $user_obj->coupon_code = $promo_code;
    if ($promo_code) {
        $stmt = $user_obj->Couponcode();
        $itemCount = $stmt->rowCount();
        if ($itemCount > 0 && $validity == 365) {
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $commission = $row['rj_artist_subscription_commision'] ?? 0;
                $user_obj->artist_id = $row['rj_artist_id'];
                $user_obj->type = 0;
                $user_obj->percentage = $commission;
                $user_obj->plan_amount = $plan_amount;
                $user_obj->paid_amount = $plan_amount;
                $user_obj->commission_amount = ($plan_amount * $commission) / 100;
            }
            $user_obj->artistCommissionLog();
        } else {
            echo "No data found";
        }
    }

    $user_obj->validity = $validity;
    $user_obj->amount = $plan_amount;
    $user_obj->paid_amount = $plan_amount;
    $user_obj->ex_date = date('Y-m-d');

    if (isset($plan_id)) {
        switch ($validity) {
            case 30:
                $user_obj->exdate = date('Y-m-d', strtotime('+1 month', time()));
                break;
            case 90:
                $user_obj->exdate = date('Y-m-d', strtotime('+3 months', time()));
                break;
            case 180:
                $user_obj->exdate = date('Y-m-d', strtotime('+6 months', time()));
                break;
            case 365:
                $user_obj->exdate = date('Y-m-d', strtotime('+1 year', time()));
                break;
            default:
                // Set a default validity period if plan_id doesn't match any case
                $user_obj->exdate = date('Y-m-d', strtotime('+1 year', time()));
                break;
        }
    } else {
        // Default expiration if no plan ID is provided
        $user_obj->exdate = date('Y-m-d', strtotime('+1 year', time()));
    }

    $user_obj->transaction_id = $transaction_id;
    $user_obj->payment_response_data = $payment_response_data;

    $user_obj->UpdateTransactionLogs();
    $user_obj->BuySubscription();
    // $user_obj->SubscriptionComissionUpdate();
    $user_obj->Userupdatesub();

    $result = EmailUtility::sendEmail(
        $payment->email,
        'Thank You for Subscribing!',
        '<body style="font-family: Arial, sans-serif; background-color: #f4f4f4; margin: 0; padding: 0;">
        <table width="100%" cellpadding="0" cellspacing="0" style="padding: 20px;">
            <tr>
            <td align="center">
                <table width="600" cellpadding="0" cellspacing="0" style="background-color: #ffffff; border-radius: 8px; padding: 30px; box-shadow: 0 2px 5px rgba(0,0,0,0.1);">
                <tr>
                    <td>
                    <h2 style="color: #333333;">Thank You for Subscribing!</h2>
                    <p style="font-size: 16px; color: #555555;">
                        Thank you for subscribing to <strong>Rejoice Music</strong>! We are thrilled to have you on board.
                    </p>
                    <p style="font-size: 16px; color: #555555;">
                        Plan Name: ' . $plan_name . '
                    </p>
                    <p style="font-size: 16px; color: #555555;">
                        Amount: ' . $plan_amount . '
                    </p>
                    <p style="font-size: 16px; color: #555555;">
                        Start Date: ' . $user_obj->ex_date . '
                    </p>
                    <p style="font-size: 16px; color: #555555;">
                        End Date: ' . $user_obj->exdate . '
                    </p>
                    <p style="font-size: 16px; color: #555555;">
                        You have just taken the first step toward <strong>getting exclusive access to the latest updates, offers, and premium content</strong>. We are committed to providing you with a great experience and valuable content that helps you <strong>stay informed and ahead of the curve</strong>.
                    </p>
                    <p style="font-size: 16px; color: #555555;">
                        If you have any questions or need help getting started, feel free to reach out. we are always here for you.
                    </p>
                    <p style="font-size: 16px; color: #555555;">
                        Once again, thank you for joining us. Stay tuned for exciting things ahead!
                    </p>
                    </td>
                </tr>
                </table>
            </td>
            </tr>
        </table>
    </body>'
    );

    echo json_encode(array("status" => "Success"));
} else {

    echo json_encode(array("status" => "Error", 'Mesaage' => 'Payment Failed'));
}
