<?php
//inlcude headers
require_once('../../common/header.php');

use Rakit\Validation\Validator;



if ($_SERVER['REQUEST_METHOD'] === "POST") {



    $data = json_decode(file_get_contents("php://input"), true);

    // Ensure the decoded data is an array
    if (!is_array($data)) {
        echo json_encode(["status" => "error", "message" => "Invalid input data"]);
        exit;
    }


    $validator = new Validator;

    // make it
    $validation = $validator->make($data, [
        'name' => 'required',
        'pincode' => 'required|min:6',
        'state' => 'required',
        'city'    => 'required',
        'district' => 'required'
    ]);

    // then validate
    $validation->validate();

    if ($validation->fails()) {
        // handling errors
        $errors = $validation->errors();
        echo json_encode(array("status" => 'error', "errors" => $errors->firstOfAll()));
        exit;
    }

    $content_obj->name = $data['name'];
    $content_obj->pincode = $data['pincode'];
    $content_obj->state = $data['state'];
    $content_obj->city = $data['city'];
    $content_obj->district = $data['district'];

    $addChurch = $content_obj->addChurch();

    if ($addChurch) {

        $church = [
            'id' => $addChurch,
            'name' => $data['name']
        ];
        echo json_encode(array("status" => true, "msg" => "Church added successfully!", "data" => $church));
    } else {
        echo json_encode(array("status" => false, "msg" => "Something is wrong!"));
    }
}
