<?php
//inlcude headers
require_once('../../common/header.php');
require_once('../../common/request.php');


$validate = validateToken();
if ($validate) {
    $user = $validate->data;
    $deatils = $artist_obj->ProfileDetail($user->id);

    $podcast_obj->artist_id = $user->id;
    if (!empty($deatils)) {
        $podcast_obj->limit = $_GET['limit'] ?? 10;
        $podcast_obj->offset = $_GET['offset'] ?? 0;
        $podcast_obj->search = $_GET['search'] ?? null;

        $stmt = $podcast_obj->UpcomingPodcast();
        $itemCount = $stmt->rowCount();

        $total = $podcast_obj->artistUpcomingPodcast();
        // $total = $total->rowCount();

        if ($itemCount > 0) {
            $data = array();
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {

                $date = $row['rj_podcast_date'];
                $rj_podcast_status = $row['rj_podcast_status'];
                $rj_podcast_live_status = $row['rj_podcast_live_status'];
                $rj_podcast_cover = $row['rj_podcast_cover'];

                if ($rj_podcast_status == '0') {
                    $status = 'Pending';
                } else if ($rj_podcast_status == '2') {
                    $status = 'Cancelled, Kindly Re Schedule';
                } else if ($rj_podcast_status == '1') {
                    $status = 'Approved';
                }
                date_default_timezone_set('Asia/Kolkata');

                // Convert your date to DateTime formats
                $newDates = new DateTime($date); // Scheduled date & time

                // Create +/- 10 minutes windows
                $startTime    = (clone $newDates)->modify('+10 minutes');  // Scheduled +10 min
                $startingTime = (clone $newDates)->modify('-10 minutes');  // Scheduled -10 min
                $newDate1  = $newDates->format("d M Y");
                $newDate2  = $newDates->format("H:i:s");
                $newDate   = $newDates->format("d M Y h:i A");
                $endTime = $startTime->format("d M Y h:i A");
                
                // Current time
                $dates = new DateTime(); // now

                // Default status
                $statussss = "Upcoming";

                // Case 1: Podcast completed manually
                if ($rj_podcast_live_status == 3) {
                    $statussss = "Completed";
                }
                // Case 2: Live (scheduled time → scheduled +10 minutes)
                else if ($dates >= $newDates && $dates <= $startTime) {
                    $statussss = "Live";
                }
                // Case 3: Going to start (10 minutes before → scheduled time)
                else if ($dates >= $startingTime && $dates < $newDates) {
                    $statussss = "Going To Start";
                }
                // Case 4: Time passed beyond +10 min window → Cancelled
                else if ($dates > $startTime && $rj_podcast_live_status != 3) {
                    $statussss = "Cancelled";
                }
                // // Case 5: Otherwise still upcoming
                // else if ($dates < $startingTime) {
                //     $statussss = "Upcoming";
                // }


                // // Case 6:  but status is not marked as completed/live

                // if (($rj_podcast_status == '0') && $dates > $startingTime) {
                //     $statussss = 'Cancelled, Kindly Re Schedule';
                //     // $status = 'Cancelled, Kindly Re Schedule';

                // }

                // // Case 7:  but status is not marked as completed/live
                // if (($rj_podcast_status == '1') && $dates > $startingTime) {
                //     $statussss = 'Cancelled, Kindly Re Schedule';
                //     // $status = 'Cancelled, Kindly Re Schedule';

                // }

                $data[] = array(
                    "podcast_id" => $row['rj_podcast_id'],
                    "podcast_unique_id" => 'RJ_Live_' . $row['rj_podcast_id'],
                    "podcast_title" => $row['rj_podcast_title'],
                    "rj_podcast_category_title" => $row['rj_podcast_category_title'],
                    "rj_podcast_category_id" =>  $row['rj_podcast_category_id'],
                    "rj_podcast_type" => $row['rj_podcast_type'],
                    "live_time" => $newDate,
                    "scheduled_date" => $newDate1,
                    "scheduled_time" => $newDate2,
                    "cover" => $rj_podcast_cover,
                    "status" => $status,
                    "pod_status" => $statussss,
                    "podcast_end_time" => $endTime,
                    "duration" => $row['rj_podcast_duration'],
                    "podcast_link" => $row['rj_podcast_link'],
                );
            }
        } else {
            $data = array();
        }

        echo json_encode(array("status" => "Success", "Upcoming_List" => $data, 'total' => $total->rowCount()));
    }
}
