<?php
//inlcude headers
require_once('../../common/header.php');
require_once('../../common/request.php');

require_once __DIR__ . '/../../vendor/autoload.php';
require_once __DIR__ . '/../../utils/FCMNotification.php';

use Utils\FCMNotification;
date_default_timezone_set("Asia/Calcutta");
$credentialsPath = __DIR__ .'/../../rejoice-music-firebase-adminsdk-fbsvc-880ca1e1ae.json';
$projectId = 'rejoice-music';

if ($_SERVER['REQUEST_METHOD'] === "POST") {

    $validate = validateToken();
    if ($validate) {
        $user = $validate->data;
        $deatils = $artist_obj->ProfileDetail($user->id);

        if (!empty($deatils)) {

            $data = json_decode(file_get_contents("php://input"));

            // set product property values            
            $podcast_obj->artist_id = $user->id;
            $user_obj->artist_id = $user->id;
            $podcast_obj->podcast_id = $data->podcast_id;

            $podcast_id = 'RJ_Live_'.$data->podcast_id;

            //
            $checkTime = $podcast_obj->getPodcast();
            $checkTime = $checkTime->fetch(PDO::FETCH_ASSOC);

            $currentTime = new DateTime("now", new DateTimeZone('Asia/Kolkata'));
            $scheduledTime = new DateTime($checkTime['rj_podcast_date'], new DateTimeZone('Asia/Kolkata'));

            $checkPodcast = $podcast_obj->checkActivePodcast();

            // Calculate the difference
            $interval = $currentTime->diff($scheduledTime);

            // Convert the difference to minutes
            $minutesDiff = ($interval->days * 24 * 60) + ($interval->h * 60) + $interval->i;

            // If the scheduled time is in the past, make the difference negative
            if ($currentTime > $scheduledTime) {
                $minutesDiff = -$minutesDiff;
            }

            if (abs($minutesDiff) <= 10) {


                if ($checkPodcast->rowCount() > 0) {
                    echo json_encode(array("status" => false, "msg" => "Admin Under Review"));
                    exit();
                }

                $addalbum = $podcast_obj->StartPodcast();

                if ($addalbum) {

                    function GenerateSignature($appId, $signatureNonce, $serverSecret, $timestamp)
                    {
                        $str = $appId . $signatureNonce . $serverSecret . $timestamp;
                        $signature = md5($str);
                        return $signature;
                    }

                    //Generate a random hex string of 16 hex digits.
                    $signatureNonce = bin2hex(random_bytes(8));
                    //Use the AppID and ServerSecret of your project.
                    // $appId = 634149969;
                    // $serverSecret = "8563df43f94caba4fb07c28e6700e6e3";
                    $appId = 389453178;
                    $serverSecret = "6b80186afe99be8dc19cb16910dc09e6";
                    $timestamp = time();
                    $signature = GenerateSignature($appId, $signatureNonce, $serverSecret, $timestamp);
                    $signature;


                    $url = "https://cloudrecord-api.zego.im/?Action=StartRecord&AppId=$appId&SignatureNonce=$signatureNonce&Timestamp=$timestamp&Signature=$signature&SignatureVersion=2.0&IsTest=false";
                    $headers = array(
                        'Content-Type:application/json;charset=utf-8'
                    );
                    $apiBody = [
                        "RoomId" => $podcast_id,
                        "RecordInputParams" => [
                            "RecordMode" => 1,
                            "StreamType" => 1
                        ],
                        "RecordOutputParams" => [
                            "OutputFileFormat" => "mp3",
                            "OutputFolder" => "artist/recorded-podcasts/"
                        ],
                        "StorageParams" => [
                            "Vendor" => 1,
                            "Region" => "ap-south-1",
                            "Bucket" => "rejoicemusic",
                            "AccessKeyId" => "AKIAWT7MQUAPHQEXBREY",
                            "AccessKeySecret" => "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",
                        ]

                    ];

                    // "StorageParams" => [
                    //         "Vendor" => 1,
                    //         "Region" => "us-east-1",
                    //         "Bucket" => "rejoice",
                    //         "AccessKeyId" => "AKIA6AWFHKXLJWF522WY",
                    //         "AccessKeySecret" => "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",
                    //     ]

                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $url);
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($apiBody));
                    $result = curl_exec($ch);

                    $result = json_decode($result);
                    $task_id = '';
                    if($result->Message === 'succeed'){
                        $task_id = $podcast_obj->task_id = $result->Data->TaskId;
                        $podcast_obj->updateTaskId();
                    }

                    $followers = $user_obj->getFollowersList();
                    $followers = $followers->fetchAll(PDO::FETCH_OBJ);
                
                    foreach($followers  as $follower){
                        if(!empty($follower->device_token)){
                            $title = "Podcast Started";
                            $msg = "Podcast ".$checkTime['rj_podcast_title']." is started now";
                            $fcm = new FCMNotification($credentialsPath, $projectId);
                            $response = $fcm->sendNotification($follower->device_token, $title, $msg, []);

                            $date = date('Y-m-d');
                            $time = date('H:i:s');
                            $stmt = $connection->prepare("INSERT INTO user_notifications 
                                                            (notify_title, notify_description, notify_image, notify_url, notify_date, notify_time, notify_art_id)
                                                            VALUES (:title, :description, :image, :url, :date, :time, :art_id)
                                                            ");

                            $stmt->execute([
                            ':title'       => $title,
                            ':description' => $msg,
                            ':image'       => null,
                            ':url'         => null,
                            ':date'        => $date,
                            ':time'        => $time,
                            ':art_id'      => $follower->rj_cus_id
                            ]);

                        }
                    }

                    echo json_encode(array("status" => true, "msg" => "Podcast Started Successfully!", "task_id" =>$task_id, "result" => $result));
                    exit;

                } else {
                    echo json_encode(array("status" => false, "msg" => "Something is wrong!"));
                }
            } else {
                echo json_encode(array("status" => true, "msg" => "Podcast start is not allowed yet"));
            }
        }
    }
}
