<?php
//inlcude headers
require_once('../../common/header.php');
require_once('../../common/request.php');

date_default_timezone_set('Asia/Kolkata');

$validate = validateToken();
if ($validate) {
    $user = $validate->data;
    $deatils = $artist_obj->ProfileDetail($user->id);

    $album_obj->artist_id = $user->id;
    $artist_obj->artist_id = $user->id;
    $album_obj->limit = 10;
    $album_obj->offset = 0;

    if (!empty($deatils)) {
        $album = $album_obj->artistAlbum();
        $itemCount = $album->rowCount();
        if ($itemCount > 0) {
            $album_data = array();
            while ($row = $album->fetch(PDO::FETCH_ASSOC)) {

                $cover = $row['rj_album_cover'];

                $album_data[] = array(
                    "album_id" => $row['rj_album_id'],
                    "album_name" => $row['rj_ablum_title'],
                    "album_cover" => $cover
                );
            }
        } else {
            $album_data = array();
        }

        $song_obj->artist_id = $user->id;
        $song_obj->limit = 10;
        $song_obj->offset = 0;
        $song = $song_obj->CountSongs();
        $all = $song_obj->allCountSongs();
        $SongCount = $song->rowCount();

        if ($SongCount > 0) {
            $datasong = array();
            while ($row = $song->fetch(PDO::FETCH_ASSOC)) {
                //            $data = array($row);
                $date = $row['rj_song_added_date'];

                $newDate = date("d-m-Y", strtotime($date));

                $ap_status = $row['rj_song_status'];
                if ($ap_status == 0) {
                    $status = 'Pending Approval';
                } else {
                    $status = 'Approved';
                }
                $song_obj->song_id = $row['rj_song_id'];

                $stmts = $song_obj->TotalSongPlayTime();
                $itemCounts = $stmts->rowCount();
                if ($itemCounts > 0) {
                    while ($rows = $stmts->fetch(PDO::FETCH_ASSOC)) {
                        $totaltimes = $rows['totaltime'];
                    }
                } else {
                    $totaltimes = "0";
                }

                if ($totaltimes != '') {
                    $total_plays = $totaltimes;
                } else {
                    $total_plays = "0";
                }
                $cover = $row['rj_song_cover'];
                $datasong[] = array(
                    "rj_song_id" => $row['rj_song_id'],
                    "rj_song_title" => $row['rj_song_title'],
                    "cover" => $cover,
                    "add_date" => $newDate,
                    "song_artist" => $row['rj_song_artist'],
                    "status" => $status,
                    "song_link" => $row['rj_song_audio'],
                    "playtime" => "$total_plays Min"
                );
            }
        } else {
            $datasong = array();
        }

        $podcast_obj->artist_id =  $user->id;
        $podcast_obj->limit = 10;
        $podcast_obj->offset = 0;
        $podcast = $podcast_obj->MyPodCat();
        $itemCount = $podcast->rowCount();

        if ($itemCount > 0) {
            $catdata = array();
            while ($row = $podcast->fetch(PDO::FETCH_ASSOC)) {

                $cat_title = $row['rj_podcast_category_title'];
                $podcast_obj->podcast_category = $row['rj_podcast_category_id'];

                $stmts = $podcast_obj->MyPodcast();
                $itemCounts = $stmts->rowCount();
                if ($itemCounts > 0) {
                    $catdatas = array();
                    while ($rows = $stmts->fetch(PDO::FETCH_ASSOC)) {
                        $rj_podcast_cover = $rows['rj_podcast_cover'];
                        $date = $rows['rj_podcast_date'];
                        $newDate = date("d M Y h:i A", strtotime($date));
                        $rj_podcast_status = $rows['rj_podcast_status'];
                        $rj_podcast_live_status = $rows['rj_podcast_live_status'];
                        $rj_podcast_cover = $rows['rj_podcast_cover'];

                        if ($rj_podcast_status == '0') {
                            $status = 'Pending';
                        } else if ($rj_podcast_status == '2') {
                            $status = 'Cancelled, Kindly Re Schedule';
                        } else {
                            $status = 'Approved';
                        }

                        if ($rj_podcast_live_status == '1') {
                            $live = 'Upcoming';
                        } else if ($rj_podcast_live_status == '2') {
                            $live = 'Live';
                        } else {
                            $live = 'Completed';
                        }

                        $newDates = date("Y-m-d H:i:s", strtotime($date));
                        $newDate = date("d M Y h:i A", strtotime($date));
                        $newDate1 = date("d M Y", strtotime($date));
                        $newDate2 = date("h:i:s", strtotime($date));

                        $time = strtotime($newDates);
                        $startTime = date("Y-m-d H:i:s", strtotime('+10 minutes', $time));
                        $startingTime = date("Y-m-d H:i:s", strtotime('-10 minutes', $time));
                        $dates = date('Y-m-d H:i:s');


                        $start_date = new DateTime("$dates");
                        $since_start = $start_date->diff(new DateTime("$newDates"));
                        $since_start->i . ' minutes<br>';

                       // Default status
                    $statussss = "Upcoming";

                    // Case 1: Podcast is completed manually
                    if ($rj_podcast_live_status == 3) {
                        $statussss = "Completed";
                    }
                    // Case 2: Current time is between scheduled time and 10 minutes after
                    else if ($dates >= $newDates && $dates <= $startTime) {
                        $statussss = "Live";
                    }
                    // Case 3: Current time is between 10 minutes before and the scheduled time
                    else if ($dates >= $startingTime && $dates < $newDates) {
                        $statussss = "Going To Start";
                    }
                    // Case 4: Time has passed beyond the start window, but status is not marked as completed/live
                    else if ($dates > $startTime && !in_array($rj_podcast_live_status, [1, 3])) {
                        $statussss = "Cancelled";
                    }
                    // Case 5: If none of the above, it's still upcoming
                    else if ($dates < $startingTime) {
                        $statussss = "Upcoming";
                    }

                    if($rows['rj_podcast_type'] == 2){
                        $statussss = "Completed";
                    }
                        $catdatas[] = array(
                            "podcast_id" => $rows['rj_podcast_id'],
                            "podcast_unique_id" => 'RJ_Live_' . $rows['rj_podcast_id'],
                            "podcast_title" => $rows['rj_podcast_title'],
                            "rj_podcast_category_title" => $rows['rj_podcast_category_title'],
                            "rj_podcast_category_id" =>  $row['rj_podcast_category'] ?? '',
                            "rj_podcast_type" => $rows['rj_podcast_type'],
                            "artist_id" => $rows['rj_podcast_artist_id'],
                            "live_time" => $newDate,
                            "scheduled_date" => $newDate1,
                            "scheduled_time" => $newDate2,
                            "cover" => $rj_podcast_cover,
                            "status" => $status,
                            "pod_status" => $statussss,
                            "podcast_end_time" => $startTime,
                            "duration" => $rows['rj_podcast_duration'],
                            "podcast_link" => $rows['rj_podcast_link']
                        );
                    }
                } else {
                    $catdatas = array();
                }

                $catdata[] = array("Heading" => $cat_title, "Podcast List" => $catdatas);
            }
        } else {
            $catdatas = array();
        }


        // Get Promo Count
        $stmt = $artist_obj->PromoCount();
        $promoCount = $stmt->rowCount();

        // Get Promo Amount
        $stmt = $artist_obj->PromoAmount();
        $promo_result = $stmt->fetch(PDO::FETCH_ASSOC);
        $promoAmountCount = $stmt->rowCount();
        $amount = $promoAmountCount > 0 ? $promo_result['total_commission'] : '0';

        // Get Total Play Time
        $stmt = $artist_obj->TotalPlayTime();
        $totalPlayTimeCount = $stmt->rowCount();
        $total_play = $totalPlayTimeCount > 0 ? $stmt->fetch(PDO::FETCH_ASSOC)['totaltime'] : "0";
        $total_play_earning = $total_play * 10;

        // Get Song Commission
        $stmt = $artist_obj->SongCommission();
        $itemCount = $stmt->rowCount();
        if ($itemCount > 0) {
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $songCommission = isset($row['total_commission'])?number_format($row['total_commission'], 2):0;
                $total_views = $row['total_views'];
            }
        } else {
            $songCommission = "0";
            $total_views = "0";
        }

        echo json_encode(array(
            "status" => "Success",
            "album_list" => $album_data,
            "song_list" => $datasong,
            "podcast" => $catdatas,
            'song_count' => $all->rowCount(),
            "total_subsciption" => $promoCount,
            "total_song_royality_earning" => $songCommission,
            "total_promo_earning" => $amount,
        ));
    }
}
