<?php
//inlcude headers
require_once('../../common/header.php');
require_once('../../common/request.php');

if ($_SERVER['REQUEST_METHOD'] === "POST") {

    $validate = validateToken();
    if ($validate) {
        $user = $validate->data;
        
        $deatils = $artist_obj->ProfileDetail($user->id);
        $data = json_decode(file_get_contents("php://input"));

        if (!empty($deatils)) {

            if(password_verify($data->old_password, $deatils['rj_artist_password'])){
               
                $new_password = $data->new_password;
                $confirm_password = $data->confirm_password;
            
                // Validate that new_password and confirm_password match
                if ($new_password !== $confirm_password) {
                    http_response_code(400);
                    echo json_encode(['status' => false, 'message' => 'Passwords do not match']);
                    exit;
                }
            
                $result = $artist_obj->updateforPassword($user->phone, password_hash($new_password, PASSWORD_DEFAULT));
            
                http_response_code($result['status'] ? 200 : 400);
                echo json_encode($result);
            }else{
                http_response_code(400);
                echo json_encode(['status' => false, 'message' => 'Old passwords do not match']);
            }
        }
    }
}
