<?php
require_once('../../common/header.php');
require_once('../../common/request.php');
include_once("../../config/Database.php");

use Aws\S3\S3Client;
use Aws\S3\Exception\S3Exception;

$accessKeyId = 'AKIAWT7MQUAPHQEXBREY';
$secretAccessKey = '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';
$bucketName = 'rejoicemusic';
$s3Folder = 'artist/album/';
$region = 'ap-south-1';

$s3 = new S3Client([
    'version' => 'latest',
    'region' => 'ap-south-1', // Change to your desired region
    'credentials' => [
        'key' => $accessKeyId,
        'secret' => $secretAccessKey,
    ],
]);

$db = new Database();
$connection = $db->connect();

if ($_SERVER['REQUEST_METHOD'] !== "POST") {
    echo json_encode(["status" => false, "msg" => "Invalid request"]);
    exit;
}

$validate = validateToken();
if (!$validate) {
    echo json_encode(["status" => false, "msg" => "Unauthorized"]);
    exit;
}

$user = $validate->data;


// =====================================================
// FETCH MULTIPLE ROWS
// =====================================================

$rows = count($_POST['title']);

if ($rows == 0) {
    echo json_encode(["status" => false, "msg" => "No songs submitted"]);
    exit;
}


// =====================================================
// PREPARE STATEMENT
// =====================================================

$sql = "INSERT INTO rj_song (
    rj_song_ablum_id,
    rj_artist_id,
    rj_category_id,
    rj_song_title,
    rj_song_artist,
    rj_song_lyricist,
    rj_song_composition,
    rj_song_music,
    rj_song_isrc_code,
    rj_song_label_name,
    rj_song_instrument_type,
    rj_song_parental_advisory,
    rj_song_date_of_production,
    rj_song_audio,
    rj_song_cover,
    rj_song_lyrics_language,
    rj_song_status,
    rj_song_isDeleted
) VALUES (
    :album_id,
    :artist_id,
    :category_id,
    :title,
    :primary_artist,
    :lyricist,
    :composition,
    :music,
    :isrc,
    :label,
    :instrument,
    :parental,
    :production_date,
    :audio,
    :cover,
    :language,
    0,
    0
)";

$stmt = $connection->prepare($sql);


// =====================================================
// LOOP ALL SONGS
// =====================================================

$errors = [];
$successCount = 0;

for ($i = 0; $i < $rows; $i++) {

    // ------------------------
    // MATCH FILES
    // ------------------------

    $audioFile = $_FILES['audio']['tmp_name'][$i] ?? null;
    $coverFile = $_FILES['cover']['tmp_name'][$i] ?? null;

    if (!$audioFile || !$coverFile) {
        $errors[] = "Row $i: Missing audio or cover file";
        continue;
    }

    // ------------------------
    // UPLOAD AUDIO
    // ------------------------

    $s3Folder = 'artist/songs/';
    
    $fileName = $_FILES["audio"]["name"][$i];
    $tmpFile = $_FILES["audio"]["tmp_name"][$i];
        try {
            // Get original file extension
            $ext = pathinfo($fileName, PATHINFO_EXTENSION);

            // Generate new unique filename
            $newFileName = 'song_' . time() . '_' . $i . '.' . $ext;

            $s3->putObject([
                'Bucket' => $bucketName,
                'Key'    => $s3Folder . $newFileName,
                'Body'   => fopen($tmpFile, 'rb'),
                'ACL'    => 'public-read'  // IMPORTANT
            ]);

            $audioURL = "https://$bucketName.s3.$region.amazonaws.com/$s3Folder$newFileName";
        } catch (Exception $e) {
           $errors[] = "Row $i: Audio upload failed";
           continue;
        }
    
    // ------------------------
    // UPLOAD COVER
    // ------------------------

    $coverName = uniqid() . "_" . $_FILES["cover"]["name"][$i];

    try {
        $s3->putObject([
            'Bucket' => $bucketName,
            'Key' => "artist/covers/" . $coverName,
            'Body' => fopen($coverFile, 'rb'),
            'ACL' => 'public-read'
        ]);
        $coverURL = "https://$bucketName.s3.$region.amazonaws.com/artist/covers/$coverName";

    } catch (Exception $e) {
        $errors[] = "Row $i: Cover upload failed";
        continue;
    }


    // ------------------------
    // PREPARE DATA
    // ------------------------

    $album_id   = $_POST['album_id'][$i];
    $cat_id     = $_POST['cat_id'][$i];
    $title      = $_POST['title'][$i];
    $language   = $_POST['lyrics_language'][$i];

    // ------------------------
    // INSERT ROW
    // ------------------------

    $stmt->execute([
        ':album_id'         => $album_id,
        ':artist_id'        => $user->id,
        ':category_id'      => $cat_id,
        ':title'            => $title,
        ':primary_artist'   => $_POST['primary_artist'][$i]??'',
        ':lyricist'         => $_POST['lyricist'][$i]??'',
        ':composition'      => $_POST['composition'][$i]??'',
        ':music'            => $_POST['music'][$i]??'',
        ':isrc'             => $_POST['isrc_code'][$i]??'',
        ':label'            => $_POST['label_name'][$i]??'',
        ':instrument'       => $_POST['instrumental_type'][$i]??'',
        ':parental'         => $_POST['parental_advisory'][$i]??'',
        ':production_date'  => $_POST['date_of_production'][$i]??'',
        ':audio'            => $audioURL,
        ':cover'            => $coverURL,
        ':language'         => $language
    ]);

    $successCount++;
}


// =====================================================
// RETURN RESPONSE
// =====================================================

echo json_encode([
    "status" => true,
    "uploaded" => $successCount,
    "errors" => $errors
]);

exit;
