<?php


class Song
{
    // Parameters to be used in songs model
    public $album_id;
    public $artist_id;
    public $cat_id;
    public $track_type;
    public $instrumental_type;
    public $title;
    public $primary_artist;
    public $featuring;
    public $lyricist;
    public $composition;
    public $music;
    public $production_year;
    public $isrc_code;
    public $genere;
    public $parental_advisory;
    public $lyrics_language;
    public $label_name;
    public $date_of_production;
    public $rj_song_duration;
    public $newdate;
    public $song_id;
    public $audio;
    public $vocals;
    public $audios;
    public $cover;
    public $limit;
    public $offset;
    public $cus_id;
    public $remarks;
    public $user_id;
    public $date;
    public $time;
    public $search;
    public $status;

    private $conn;
    private $tbl;

    public function __construct($db)
    {
        $this->conn = $db;
        $this->tbl = "rj_song";
    }


    public function AddSong()
    {
        $sqlQuery = "INSERT INTO `rj_song` SET 
                                               `rj_song_ablum_id` = :album_id, 
                                               `rj_artist_id` = :artist_id, 
                                               `rj_song_track_type` = :track_type, 
                                               `rj_song_instrument_type` = :instrumental_type,
                                               `rj_song_title` = :title, 
                                               `rj_song_artist` = :primary_artist, 
                                               `rj_song_featuring` = :featuring, 
                                               `rj_song_lyricist` = :lyricist,
                                               `rj_song_composition` = :composition,
                                               `rj_song_music` = :music,
                                               `rj_song_production_year` = :production_year,
                                               `rj_song_isrc_code` = :isrc_code, 
                                               `rj_song_genere` = :genere,
                                               `rj_song_parental_advisory` = :parental_advisory,
                                               `rj_song_lyrics_language` = :lyrics_language, 
                                               `rj_song_label_name` = :label_name, 
                                               `rj_song_date_of_production` = :date_of_production, 
                                               `rj_song_duration` = :rj_song_duration, 
                                               `rj_song_approved_status` = '0', 
                                               `rj_song_added_date` = :newdate,
                                               `rj_song_audio` = :audio,
                                               `rj_song_vocals` = :vocals,
                                                `rj_song_cover` = :cover,
                                                `rj_category_id` = :cat_id
                                               ";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(':album_id', $this->album_id);
        $stmt->bindParam(':artist_id', $this->artist_id);
        $stmt->bindParam(':track_type', $this->track_type);
        $stmt->bindParam(':instrumental_type', $this->instrumental_type);
        $stmt->bindParam(':title', $this->title);
        $stmt->bindParam(':primary_artist', $this->primary_artist);
        $stmt->bindParam(':featuring', $this->featuring);
        $stmt->bindParam(':lyricist', $this->lyricist);
        $stmt->bindParam(':composition', $this->composition);
        $stmt->bindParam(':music', $this->music);
        $stmt->bindParam(':production_year', $this->production_year);
        $stmt->bindParam(':isrc_code', $this->isrc_code);
        $stmt->bindParam(':genere', $this->genere);
        $stmt->bindParam(':parental_advisory', $this->parental_advisory);
        $stmt->bindParam(':lyrics_language', $this->lyrics_language);
        $stmt->bindParam(':label_name', $this->label_name);
        $stmt->bindParam(':date_of_production', $this->date_of_production);
        $stmt->bindParam(':rj_song_duration', $this->rj_song_duration);
        $stmt->bindParam(':newdate', $this->newdate);
        $stmt->bindParam(':audio', $this->audio);
        $stmt->bindParam(':vocals', $this->vocals);
        $stmt->bindParam(':cover', $this->cover);
        $stmt->bindParam(':cat_id', $this->cat_id);

        $stmt->execute();
        return $stmt;
    }


    public function SongDetail()
    {
        $query = "SELECT * FROM " . $this->tbl . " 
                           JOIN rj_album ON rj_album.rj_album_id = rj_song.rj_song_ablum_id
                           WHERE rj_song.rj_artist_id = :artist_id AND rj_song.rj_song_id = :song_id";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':artist_id', $this->artist_id, PDO::PARAM_INT);
        $stmt->bindParam(':song_id', $this->song_id, PDO::PARAM_INT);

        $stmt->execute();
        return $stmt;
    }

    public function CountSongs()
    {
        $query = "SELECT * FROM " . $this->tbl . " WHERE rj_artist_id = :artist_id AND rj_song_isDeleted = '0' order by rj_song_id DESC LIMIT :limit OFFSET :offset";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':artist_id', $this->artist_id, PDO::PARAM_INT);
        $stmt->bindParam(":limit", $this->limit, PDO::PARAM_INT);
        $stmt->bindParam(":offset", $this->offset, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt;
    }

    public function allCountSongs()
    {
        $query = "SELECT * FROM " . $this->tbl . " WHERE rj_artist_id = :artist_id AND rj_song_isDeleted = '0' order by rj_song_id DESC";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':artist_id', $this->artist_id, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt;
    }

    public function artistSongs()
    {
        $query = "SELECT s.*, 
                 c.category_title, 
                 a.rj_ablum_title
          FROM {$this->tbl} AS s
          LEFT JOIN rj_song_category AS c 
                 ON c.id = s.rj_category_id
          LEFT JOIN rj_album AS a 
                 ON a.rj_album_id = s.rj_song_ablum_id
          WHERE s.rj_artist_id = :artist_id
            AND s.rj_song_isDeleted = '0'";

        if (!empty($this->search)) {
            $query .= " AND s.rj_song_title LIKE :title";
        }
        if (!empty($this->status)) {
            $query .= " AND s.approve_status LIKE :status";
        }

        $query .= " ORDER BY s.rj_song_id DESC 
            LIMIT :limit OFFSET :offset";

        $stmt = $this->conn->prepare($query);

        if (!empty($this->search)) {
            $searchTerm = "%{$this->search}%";
            $stmt->bindParam(':title', $searchTerm, PDO::PARAM_STR);
        }
        if (!empty($this->status)) {
            $stmt->bindParam(':status', $this->status, PDO::PARAM_INT);
        }

        $stmt->bindParam(':artist_id', $this->artist_id, PDO::PARAM_INT);
        $stmt->bindParam(':limit', $this->limit, PDO::PARAM_INT);
        $stmt->bindParam(':offset', $this->offset, PDO::PARAM_INT);

        $stmt->execute();

        return $stmt;
    }


    public function TotalSongPlayTime()
    {
        $query = "SELECT SUM(timeing) as totaltime FROM `rj_song_playtime` WHERE rj_song_id = :song_id";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':song_id', $this->song_id, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt;
    }

    public function AllSongDetail()
    {
        $query = "SELECT * FROM " . $this->tbl . " LEFT JOIN rj_album ON rj_album.rj_album_id = rj_song.rj_song_ablum_id WHERE rj_song.rj_song_id = :song_id";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':song_id', $this->song_id, PDO::PARAM_INT);

        $stmt->execute();
        return $stmt;
    }

    // public function AllSongs()
    // {
    //     $query = "SELECT * FROM " . $this->tbl . " where rj_song_status > 0 order by rj_song_id DESC LIMIT :limit OFFSET :offset";
    //     $stmt = $this->conn->prepare($query);
    //     $stmt->bindParam(':limit', $this->limit, PDO::PARAM_INT);
    //     $stmt->bindParam(':offset', $this->offset, PDO::PARAM_INT);

    //     $stmt->execute();

    //     return $stmt;
    // }

    public function AllSongs()
    {
        $query = "SELECT * FROM " . $this->tbl . " WHERE rj_song_status > 0 AND approve_status = 1 AND rj_song_isDeleted = 0";

        if (!empty($this->search)) {
            $query .= " AND rj_song_title LIKE :title";
        }

        if($this->limit > 0){
                $query .= " ORDER BY rj_song_id DESC LIMIT :limit OFFSET :offset";
        }else{
                $query .= " ORDER BY rj_song_id DESC";
        }
        $stmt = $this->conn->prepare($query);

        if (!empty($this->search)) {
            $searchTerm = "%{$this->search}%";
            $stmt->bindParam(':title', $searchTerm, PDO::PARAM_STR);
        }
        if($this->limit > 0){
        $stmt->bindParam(':limit', $this->limit, PDO::PARAM_INT);
        $stmt->bindParam(':offset', $this->offset, PDO::PARAM_INT);
        }
        $stmt->execute();

        return $stmt;
    }


    public function allsongcount()
    {
        $query = "SELECT * FROM " . $this->tbl . " where rj_song_isDeleted = 0 order by rj_song_id DESC";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    public function EditSong()
    {
        $sqlQuery = "UPDATE `rj_song` SET 
                                               `rj_song_ablum_id` = :album_id, 
                                               `rj_artist_id` = :artist_id, 
                                               `rj_song_track_type` = :track_type, 
                                               `rj_song_instrument_type` = :instrumental_type,
                                               `rj_song_title` = :title, 
                                               `rj_song_artist` = :primary_artist, 
                                               `rj_song_featuring` = :featuring, 
                                               `rj_song_lyricist` = :lyricist,
                                               `rj_song_composition` = :composition,
                                               `rj_song_music` = :music,
                                               `rj_song_production_year` = :production_year,
                                               `rj_song_isrc_code` = :isrc_code, 
                                               `rj_song_genere` = :genere,
                                               `rj_song_parental_advisory` = :parental_advisory,
                                               `rj_song_lyrics_language` = :lyrics_language, 
                                               `rj_song_label_name` = :label_name, 
                                               `rj_song_date_of_production` = :date_of_production, 
                                               `rj_song_duration` = :rj_song_duration, 
                                               `rj_song_approved_status` = '0', 
                                               `rj_song_added_date` = :newdate,
                                               `rj_song_vocals` = :vocals,
                                                `rj_song_cover` = :cover,
                                                `rj_category_id` = :cat_id

                                                WHERE `rj_song_id` = :song_id";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(':song_id', $this->song_id, PDO::PARAM_INT);
        $stmt->bindParam(':album_id', $this->album_id);
        $stmt->bindParam(':artist_id', $this->artist_id);
        $stmt->bindParam(':track_type', $this->track_type);
        $stmt->bindParam(':instrumental_type', $this->instrumental_type);
        $stmt->bindParam(':title', $this->title);
        $stmt->bindParam(':primary_artist', $this->primary_artist);
        $stmt->bindParam(':featuring', $this->featuring);
        $stmt->bindParam(':lyricist', $this->lyricist);
        $stmt->bindParam(':composition', $this->composition);
        $stmt->bindParam(':music', $this->music);
        $stmt->bindParam(':production_year', $this->production_year);
        $stmt->bindParam(':isrc_code', $this->isrc_code);
        $stmt->bindParam(':genere', $this->genere);
        $stmt->bindParam(':parental_advisory', $this->parental_advisory);
        $stmt->bindParam(':lyrics_language', $this->lyrics_language);
        $stmt->bindParam(':label_name', $this->label_name);
        $stmt->bindParam(':date_of_production', $this->date_of_production);
        $stmt->bindParam(':rj_song_duration', $this->rj_song_duration);
        $stmt->bindParam(':parental_advisory', $this->parental_advisory);
        $stmt->bindParam(':newdate', $this->newdate);
        $stmt->bindParam(':vocals', $this->vocals);
        $stmt->bindParam(':cover', $this->cover);
        $stmt->bindParam(':cat_id', $this->cat_id);


        $stmt->execute();
        return $stmt;
    }

    public function UploadAudio()
    {


        // Update query to include the song duration
        $sqlQuery = "UPDATE `rj_song` SET `rj_song_audio` = :audio, 
                                          `rj_song_vocals` = :vocals,
                                          `rj_song_cover` = :cover,
                                      WHERE `rj_song_id` = :song_id";

        $stmt = $this->conn->prepare($sqlQuery);

        // Bind parameters
        $stmt->bindParam(':audio', $this->audio);
        $stmt->bindParam(':vocals', $this->vocals);
        $stmt->bindParam(':cover', $this->cover);
        $stmt->bindParam(':song_id', $this->song_id);

        // Execute the query
        if ($stmt->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function deleteSong()
    {
        $sqlQuery = "UPDATE `rj_song` SET `rj_song_isDeleted` = '1' WHERE `rj_song_id` = :rj_song_id";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(":rj_song_id", $this->song_id, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt;
    }

    public function deleteAlbumSong()
    {

        $sqlQuery = "UPDATE `rj_song` SET `rj_song_isDeleted` = '1' WHERE `rj_song_ablum_id` = :album_id";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(":album_id", $this->album_id);
        $stmt->execute();
        return $stmt;
    }

    public function LikeSongcheck()
    {
        $sqlQuery = "SELECT * FROM `rj_like_song` WHERE `rj_cus_id` = '$this->cus_id' AND `rj_like_song_id` = '$this->song_id'";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->execute();
        return $stmt;
    }

    public function PlayListcheck()
    {
        $sqlQuery = "SELECT * FROM `rj_playlist` WHERE `rj_cus_id` = '$this->cus_id' AND `rj_song_id` = '$this->song_id'";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->execute();
        return $stmt;
    }

    public function reportSong()
    {
        $sqlQuery = "INSERT INTO `report_songs` (`song_id`, `user_id`, `remarks`) 
                     VALUES (:song_id, :user_id, :remarks)";

        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(':song_id', $this->song_id, PDO::PARAM_INT);
        $stmt->bindParam(':user_id', $this->user_id, PDO::PARAM_INT);
        $stmt->bindParam(':remarks', $this->remarks, PDO::PARAM_STR);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }

    public function ViewSongCount()
    {
        $sqlQuery = "SELECT * FROM `just_song_view_count` WHERE `rj_song_id` = '$this->song_id'";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->execute();
        return $stmt;
    }

    public function AddJustViewSong()
    {
        $sqlQuery = "INSERT INTO `just_song_view_count` SET `rj_cus_id` = '$this->cus_id',`rj_song_id` = '$this->song_id',`rj_view_date` = '$this->date',`rj_view_time` = '$this->time'";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->execute();
        return $stmt;
    }

    public function checkReportSong()
    {
        $sqlQuery = "SELECT * FROM `report_songs` WHERE `song_id` = '$this->song_id' AND `user_id` = '$this->cus_id'";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->execute();
        return $stmt;
    }

    public function checkDownloadSong()
    {
        $sqlQuery = "SELECT * FROM `rj_song_download` WHERE `rj_song_id` = '$this->song_id' AND `rj_cus_id` = '$this->cus_id'";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->execute();
        return $stmt;
    }
}
