<?php


class Podcast
{
    public $title;
    public $podcast_category;
    public $podcast_subcategory;
    public $artist_id;
    public $podcast_type;
    public $podcast_date;
    public $podcast_time;
    public $filename;
    public $newdate;
    public $podcast_id;
    public $roomId;
    public $limit;
    public $offset;
    public $podcast_link;
    public $user_id;
    public $task_id;
    public $search;
    public $duration;


    private $conn;
    private $tbl;

    public function __construct($db)
    {
        $this->conn = $db;
        $this->tbl = "rj_podcast";
    }


    public function AddPodcast()
    {

        $sqlQuery = "INSERT INTO " . $this->tbl . " SET 
                                                `rj_podcast_title` = :title, 
                                                `rj_podcast_category` = :podcast_category, 
                                                `rj_podcast_subcategory` = :podcast_subcategory, 
                                                `rj_podcast_artist_id` = :artist_id, 
                                                `rj_podcast_type` = :podcast_type, 
                                                `rj_podcast_date` = :podcast_date, 
                                                `rj_podcast_time` = :podcast_time,
                                                `rj_podcast_cover` = :filename,
                                                `rj_podcast_added_date` = :newdate,
                                                `rj_podcast_link` = :podcast_link";
        $stmt = $this->conn->prepare($sqlQuery);

        $date = ($this->podcast_date??date('Y-m-d H:i:s'));
        $time = ($this->podcast_time??date('H:i:s'));

        $stmt->bindParam(":title", $this->title);
        $stmt->bindParam(":podcast_category", $this->podcast_category);
        $stmt->bindParam(":podcast_subcategory", $this->podcast_subcategory);
        $stmt->bindParam(":artist_id", $this->artist_id);
        $stmt->bindParam(":podcast_type", $this->podcast_type);
        $stmt->bindParam(":podcast_date", $date);
        $stmt->bindParam(":podcast_time", $time);
        $stmt->bindParam(":filename", $this->filename);
        $stmt->bindParam(":newdate", $this->newdate);
        $stmt->bindParam(":podcast_link", $this->podcast_link);
        $stmt->execute();
        return $stmt;
    }

    public function updatePodcast()
    {
        $sqlQuery = "UPDATE " . $this->tbl . " SET 
                                                `rj_podcast_title` = :title, 
                                                `rj_podcast_category` = :podcast_category, 
                                                `rj_podcast_subcategory` = :podcast_subcategory, 
                                                `rj_podcast_artist_id` = :artist_id, 
                                                `rj_podcast_type` = :podcast_type, 
                                                `rj_podcast_date` = :podcast_date, 
                                                `rj_podcast_time` = :podcast_time,
                                                `rj_podcast_cover` = :filename,
                                                `rj_podcast_link` = :podcast_link,
                                                `rj_podcast_added_date` = :newdate WHERE `rj_podcast_id` = :podcast_id";
        $stmt = $this->conn->prepare($sqlQuery);

        $date = ($this->podcast_date??date('Y-m-d H:i:s'));
        $time = ($this->podcast_time??date('H:i:s'));

        $stmt->bindParam(":title", $this->title);
        $stmt->bindParam(":podcast_category", $this->podcast_category);
        $stmt->bindParam(":podcast_subcategory", $this->podcast_subcategory);
        $stmt->bindParam(":artist_id", $this->artist_id);
        $stmt->bindParam(":podcast_type", $this->podcast_type);
        $stmt->bindParam(":podcast_date", $date);
        $stmt->bindParam(":podcast_time", $time);
        $stmt->bindParam(":filename", $this->filename);
        $stmt->bindParam(":newdate", $this->newdate);
        $stmt->bindParam(":podcast_id", $this->podcast_id);
        $stmt->bindParam(":podcast_link", $this->podcast_link);
        $stmt->execute();
        return $stmt;
    }

    public function getPodcast()
    {
        $sqlQuery = "SELECT * FROM " . $this->tbl . " WHERE `rj_podcast_id` = :podcast_id";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(":podcast_id", $this->podcast_id);
        $stmt->execute();
        return $stmt;
    }

    public function checkActivePodcast()
    {
        $sqlQuery = "SELECT * FROM " . $this->tbl . " WHERE `rj_podcast_id` = :podcast_id AND `rj_podcast_status` = '0'";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(":podcast_id", $this->podcast_id);
        $stmt->execute();
        return $stmt;
    }


    public function StartPodcast()
    {
        $sqlQuery = "UPDATE " . $this->tbl . " SET `rj_podcast_live_status` = '2' WHERE `rj_podcast_id` = :podcast_id";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(":podcast_id", $this->podcast_id);
        $stmt->execute();
        return $stmt;
    }


    public function EndPodcast()
    {
        $sqlQuery = "UPDATE  " . $this->tbl . " SET `rj_podcast_live_status` = '3', `rj_podcast_link` = :podcast_link WHERE `rj_podcast_id` = :podcast_id";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(":podcast_id", $this->podcast_id);
        $stmt->bindParam(":podcast_link", $this->podcast_link);
        $stmt->execute();
        return $stmt;
    }

    public function MyPodCat()
    {
        $sqlQuery = "SELECT * FROM " . $this->tbl . " JOIN rj_podcast_category ON rj_podcast_category.rj_podcast_category_id = rj_podcast.rj_podcast_category where rj_podcast.rj_podcast_artist_id = '$this->artist_id' AND  rj_podcast.rj_podcast_live_status = 3 and rj_podcast.rj_podcast_IsDeleted = '0' group by rj_podcast.rj_podcast_category order by rj_podcast.rj_podcast_id desc LIMIT :limit OFFSET :offset";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(":limit", $this->limit, PDO::PARAM_INT);
        $stmt->bindParam(":offset", $this->offset, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt;
    }


   public function UpcomingPodcast()
{
    // echo $this->artist_id;
    // exit;
    $sql = "SELECT * FROM rj_podcast JOIN rj_podcast_category ON rj_podcast_category.rj_podcast_category_id = rj_podcast.rj_podcast_category WHERE rj_podcast.rj_podcast_artist_id = :artist_id AND rj_podcast.rj_podcast_type = 1 AND rj_podcast.rj_podcast_live_status <= 2 AND rj_podcast.rj_podcast_status <= 2 AND rj_podcast.rj_podcast_IsDeleted = 0";

    // Add search filter
    if (!empty($this->search)) {
        $sql .= " AND rj_podcast.rj_podcast_title LIKE :title";
    }

    // Add limit & offset only if limit exists
    if (!empty($this->limit)) {
        $sql .= " ORDER BY rj_podcast.rj_podcast_id DESC LIMIT :limit OFFSET :offset";
    } else {
        $sql .= " ORDER BY rj_podcast.rj_podcast_id DESC";
    }

    $stmt = $this->conn->prepare($sql);

    // bind artist
    $stmt->bindParam(":artist_id", $this->artist_id);

    // bind search
    if (!empty($this->search)) {
        $search = "%{$this->search}%";
        $stmt->bindParam(":title", $search);
    }

    // bind limit & offset only if needed
    if (!empty($this->limit)) {
        $stmt->bindParam(":limit", $this->limit, PDO::PARAM_INT);
        $stmt->bindParam(":offset", $this->offset, PDO::PARAM_INT);
    }

    $stmt->execute();
    return $stmt;
}



    public function MyPodcast()
    {
        $sql = "SELECT *
            FROM rj_podcast
            JOIN rj_podcast_category 
                ON rj_podcast_category.rj_podcast_category_id = rj_podcast.rj_podcast_category
            WHERE rj_podcast.rj_podcast_artist_id = :artist_id
            AND rj_podcast.rj_podcast_IsDeleted = 0
            AND (
                    rj_podcast.rj_podcast_live_status = 3 
                    OR rj_podcast.rj_podcast_type = 2
                )
            ORDER BY rj_podcast.rj_podcast_id DESC";

        // Apply limit & offset only if set
        if (!empty($this->limit)) {
            $sql .= " LIMIT :limit OFFSET :offset";
        }

        $stmt = $this->conn->prepare($sql);

        // Always bind artist ID
        $stmt->bindParam(":artist_id", $this->artist_id);

        // Bind limit + offset only when used
        if (!empty($this->limit)) {
            $stmt->bindParam(":limit", $this->limit, PDO::PARAM_INT);
            $stmt->bindParam(":offset", $this->offset, PDO::PARAM_INT);
        }

        $stmt->execute();

        return $stmt;
    }

    public function uploadPodcast()
    {
        $sqlQuery = "UPDATE  " . $this->tbl . " SET `rj_podcast_link` = :podcast_link, `rj_podcast_live_status` = '3'WHERE `rj_podcast_id` = :podcast_id";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(":podcast_link", $this->podcast_link);
        $stmt->bindParam(":podcast_id", $this->podcast_id, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt;
    }

    public function SeeMorePodcasts()
    {
        // `rj_podcast_live_status` = '3'
        $sqlQuery = "SELECT * FROM `rj_podcast` JOIN rj_podcast_category ON rj_podcast_category.rj_podcast_category_id = rj_podcast.rj_podcast_category WHERE rj_podcast.rj_podcast_status = '1' AND rj_podcast.rj_podcast_live_status = '3'";
        if ($this->podcast_category) $sqlQuery .= " and `rj_podcast_category` = '$this->podcast_category'";
        if ($this->artist_id) $sqlQuery .= " and `rj_podcast_artist_id` = '$this->artist_id'";
        if ($this->search) $sqlQuery .= " and `rj_podcast_title` = '$this->search'";
        $sqlQuery .= " order by `rj_podcast_id` DESC";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->execute();
        return $stmt;
    }

    public function RecentPodcast()
    {
        $sqlQuery = "SELECT * FROM `rj_podcast_activity` 
                     JOIN rj_podcast ON rj_podcast.rj_podcast_id = rj_podcast_activity.rj_podcast_id 
                     WHERE rj_podcast_activity.rj_cus_id = :user_id 
                     GROUP BY rj_podcast_activity.rj_play_id";

        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(':user_id', $this->user_id);
        $stmt->execute();
        return $stmt;
    }

    public function DownloadPodcast()
    {
        $sqlQuery = "SELECT do.*,pod.*, cat.*
                     FROM `rj_podcast_download` AS do
                     JOIN rj_podcast AS pod ON pod.rj_podcast_id = do.rj_podcast_id
                     JOIN rj_podcast_category AS cat ON cat.rj_podcast_category_id = pod.rj_podcast_category  
                     WHERE do.rj_cus_id = :user_id
                     GROUP BY do.rj_podcast_id";

        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(':user_id', $this->user_id);
        $stmt->execute();
        return $stmt;
    }

    public function artistPodcast()
    {
        $query = "SELECT * FROM rj_podcast 
              WHERE rj_podcast_artist_id = :artist_id 
              AND rj_podcast_live_status = '3' 
              AND rj_podcast_IsDeleted = '0'";

        if (!empty($this->search)) {
            $query .= " AND rj_podcast_title LIKE :search";
        }

        if ($this->limit !== null && $this->offset !== null) {
            $query .= " LIMIT :limit OFFSET :offset";
        }

        $stmt = $this->conn->prepare($query);

        $stmt->bindValue(':artist_id', (int)$this->artist_id, PDO::PARAM_INT);

        if (!empty($this->search)) {
            $search = "%{$this->search}%";
            $stmt->bindValue(':search', $search, PDO::PARAM_STR);
        }

        if ($this->limit !== null && $this->offset !== null) {
            $stmt->bindValue(':limit', (int)$this->limit, PDO::PARAM_INT);
            $stmt->bindValue(':offset', (int)$this->offset, PDO::PARAM_INT);
        }

        $stmt->execute();

        return $stmt;
    }
    public function artistPodcastCount()
    {
        $query = "SELECT * FROM rj_podcast 
              WHERE rj_podcast_artist_id = :artist_id 
              AND (
                        rj_podcast.rj_podcast_live_status = 3 
                        OR rj_podcast.rj_podcast_type = 2
                    )
              AND rj_podcast_IsDeleted = '0'";

        if (!empty($this->search)) {
            $query .= " AND rj_podcast_title LIKE :search";
        }

        $stmt = $this->conn->prepare($query);

        $stmt->bindValue(':artist_id', (int)$this->artist_id, PDO::PARAM_INT);

        if (!empty($this->search)) {
            $search = "%{$this->search}%";
            $stmt->bindValue(':search', $search, PDO::PARAM_STR);
        }

        $stmt->execute();

        return $stmt;
    }


    public function artistUpcomingPodcast()
    {
        $query = "SELECT * FROM rj_podcast WHERE rj_podcast_artist_id = :artist_id AND  rj_podcast.rj_podcast_live_status <= '2' AND rj_podcast.rj_podcast_type = 1  and rj_podcast.rj_podcast_status <= '2' and rj_podcast.rj_podcast_IsDeleted = '0'";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':artist_id', $this->artist_id, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt;
    }


    public function updateTaskId()
    {
        $sqlQuery = "UPDATE  " . $this->tbl . " SET `task_id` = :task_id WHERE `rj_podcast_id` = :podcast_id";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(':task_id', $this->task_id);
        $stmt->bindParam(':podcast_id', $this->podcast_id, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt;
    }

    public function checkTime()
    {
        $sqlQuery = "SELECT * FROM " . $this->tbl . " WHERE `rj_podcast_date` = :time AND `rj_podcast_approved_status` = 1";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(':time', $this->podcast_date);
        $stmt->execute();
        return $stmt;
    }
}
