<?php

class Content
{

    public $city_id;
    public $district_id;
    public $state_id;
    public $country_id;
    public $state;
    public $district;
    public $city;
    public $name;
    public $pincode;
    public $pastor_name;
    public $pod_category;


    private $conn;
    private $content_tbl;
    private $city_tbl;
    private $state_tbl;
    private $country_tbl;
    private $district_tbl;
    private $category_tbl;
    private $gener_tbl;
    private $church_tbl;
    private $podcast_tbl;

    public function __construct($db)
    {
        $this->conn = $db;
        $this->content_tbl = "rj_info";
        $this->country_tbl = "rj_country";
        $this->city_tbl = "rj_city";
        $this->state_tbl = "rj_state";
        $this->district_tbl = "rj_district";
        $this->category_tbl = "rj_podcast_category";
        $this->podcast_tbl = "rj_podcast";
        $this->gener_tbl = "rj_geners";
        $this->church_tbl = "rj_church";
    }

    public function getTerms()
    {
        $sqlQuery = "SELECT * FROM " . $this->content_tbl . " WHERE `id`= '1'";
        $stmt = $this->conn->prepare($sqlQuery);
        if ($stmt->execute()) {
            $data = $stmt->fetch(PDO::FETCH_ASSOC); // Fetch the result
            return $data;
        }
        return array();
    }

    public function churchList()
    {
        $sqlQuery = "SELECT * FROM " . $this->church_tbl . " 
        where `rj_church_city` = :city_id 
        and `rj_church_district` = :district_id 
        and `rj_church_state` = :state_id 
        ORDER BY rj_church_id DESC";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(":city_id", $this->city_id);
        $stmt->bindParam(":district_id", $this->district_id);
        $stmt->bindParam(":state_id", $this->state_id);

        $stmt->execute();
        return $stmt;
    }

    public function allchurchList()
    {
        $sqlQuery = "SELECT * FROM " . $this->church_tbl. " ORDER BY rj_church_id DESC";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->execute();
        return $stmt;
    }


    public function countryList()
    {
        $sqlQuery = "SELECT * FROM " . $this->country_tbl;
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->execute();
        return $stmt;
    }

    public function stateList()
    {
        $sqlQuery = "SELECT * FROM " . $this->state_tbl . " where `rj_country_id` = :country_id";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(":country_id", $this->country_id);
        $stmt->execute();
        return $stmt;
    }

    public function districtList()
    {
        $sqlQuery = "SELECT * FROM rj_district where `rj_state_id` = :state_id";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(":state_id", $this->state_id);
        $stmt->execute();
        return $stmt;
    }
    public function cityList()
    {
        $sqlQuery = "SELECT * FROM " . $this->city_tbl . " where `rj_district_id` = :district_id";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(":district_id", $this->district_id);
        $stmt->execute();
        return $stmt;
    }

    public function allstateList()
    {
        $sqlQuery = "SELECT * FROM " . $this->state_tbl;
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->execute();
        return $stmt;
    }

    public function alldistrictList()
    {
        $sqlQuery = "SELECT * FROM " . $this->district_tbl;
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->execute();
        return $stmt;
    }
    public function allcityList()
    {
        $sqlQuery = "SELECT * FROM " . $this->city_tbl;
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->execute();
        return $stmt;
    }

    public function generList()
    {
        $sqlQuery = "SELECT * FROM " . $this->gener_tbl . " WHERE `rj_geners_status` = '1'";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->execute();
        return $stmt;
    }

    public function langList()
    {
        $sqlQuery = "SELECT * FROM `rj_language`";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->execute();
        return $stmt;
    }

    public function trackList()
    {
        $sqlQuery = "SELECT * FROM `rj_track`";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->execute();
        return $stmt;
    }


    public function PodcastCategory()
    {
        $sqlQuery = "SELECT * FROM " . $this->category_tbl . " 
        WHERE rj_podcast_category_status = 0 
        ORDER BY rj_podcast_category_id DESC";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->execute();
        return $stmt;
    }

    public function PodcastCategoryDeatils($id)
    {
        $sqlQuery = "SELECT * FROM " . $this->podcast_tbl . "
        JOIN rj_podcast_category 
        ON rj_podcast_category.rj_podcast_category_id = rj_podcast.rj_podcast_category 
        where rj_podcast.rj_podcast_category = :pod_category 
        AND rj_podcast.rj_podcast_status = 1
        AND rj_podcast.rj_podcast_IsDeleted = 0 
        order by rj_podcast.rj_podcast_id DESC";

        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(":pod_category", $id);
        $stmt->execute();
        return $stmt;
    }

    public function songCategory()
    {
        $sqlQuery = "SELECT * FROM rj_song_category order by `id` DESC";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->execute();
        return $stmt;
    }

    public function songCategoryDetails($id)
    {
        $sqlQuery = "SELECT * FROM rj_song_category where `id` = :id order by `id` DESC";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(":id", $id);
        $stmt->execute();
        return $stmt;
    }

    public function getSongs($id)
    {
        $sqlQuery = "SELECT * FROM rj_song where `rj_category_id` = :id order by `rj_song_id` DESC";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(":id", $id);
        $stmt->execute();
        return $stmt;
    }

    public function getStateByName()
    {
        $sqlQuery = "SELECT * FROM " . $this->state_tbl . " where `rj_state_name` = :state";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(":state", $this->state);
        $stmt->execute();
        return $stmt;
    }

    public function getdistrictByName()
    {
        $sqlQuery = "SELECT * FROM " . $this->district_tbl . " where `rj_district_name` = :district";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(":district", $this->district);
        $stmt->execute();
        return $stmt;
    }

    public function getcityByName()
    {
        $sqlQuery = "SELECT * FROM " . $this->city_tbl . " where `rj_city_name` = :city";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(":city", $this->city);
        $stmt->execute();
        return $stmt;
    }

    public function addChurch()
    {
        $sqlQuery = "INSERT INTO rj_church (`rj_church_name`, `rj_church_city`, `rj_church_pincode`, `rj_church_district`, `rj_church_state`, `pastor_name`) 
             VALUES (:name, :city, :pincode, :district, :state, :pastor_name)";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(':name', $this->name);
        $stmt->bindParam(':city', $this->city);
        $stmt->bindParam(':pincode', $this->pincode);
        $stmt->bindParam(':district', $this->district);
        $stmt->bindParam(':state', $this->state);
        $stmt->bindParam(':pastor_name', $this->pastor_name);

        // Execute the statement
        $stmt->execute();

        // Fetch the last inserted ID
        $lastInsertedId = $this->conn->lastInsertId();

        return $lastInsertedId;
    }

    public function insertCity()
    {
        $query = "INSERT INTO rj_city (rj_city_name) VALUES (:name)";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':name', $this->city);
        $stmt->execute();
        return $this->conn->lastInsertId();
    }

    public function insertDistrict()
    {
        $query = "INSERT INTO rj_district (rj_district_name, rj_state_id, rj_country_id) VALUES (:name, :state_id, :country_id)";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':name', $this->district);  // assuming $this->district holds district name
        $stmt->bindParam(':state_id', $this->state_id, PDO::PARAM_INT);
        $stmt->bindParam(':country_id', $this->country_id, PDO::PARAM_INT);
        $stmt->execute();
        return $this->conn->lastInsertId();
    }
}
