<?php


class Album
{
    public $title;
    public $filename;
    public $newdate;
    public $artist_id;
    public $limit;
    public $offset;
    public $album_id;
    public $cus_id;
    public $song_id;
    public $search;

    private $conn;
    private $tbl;

    public function __construct($db)
    {
        $this->conn = $db;
        $this->tbl = "rj_album";
    }


    public function AddAlbum()
    {
        $sqlQuery = "INSERT INTO {$this->tbl} (rj_ablum_title, rj_album_cover, rj_album_date, rj_artist_id) 
             VALUES (:title, :filename, :newdate, :artist_id)";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(':title', $this->title);
        $stmt->bindParam(':filename', $this->filename);
        $stmt->bindParam(':newdate', $this->newdate);
        $stmt->bindParam(':artist_id', $this->artist_id);
        $stmt->execute();
        return $stmt;
    }

    public function editAlbum()
    {
        $sqlQuery = "UPDATE " . $this->tbl . " SET rj_ablum_title = :title, rj_album_cover = :filename WHERE rj_album_id = :rj_album_id";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(":title", $this->title);
        $stmt->bindParam(":filename", $this->filename);
        $stmt->bindParam(":rj_album_id", $this->album_id);

        $stmt->execute();
        return $stmt;
    }

    public function artistAlbums(){
        $sqlQuery = "SELECT * FROM {$this->tbl} 
                 WHERE rj_artist_id = :artist_id";

        // Add search condition if a keyword is provided
        if (!empty($this->search)) {
            $sqlQuery .= " AND rj_ablum_title LIKE :search";
        }

        $sqlQuery .= " ORDER BY rj_artist_id DESC LIMIT :limit OFFSET :offset";

        $stmt = $this->conn->prepare($sqlQuery);

        // Bind required values
        $stmt->bindValue(':artist_id', (int)$this->artist_id, PDO::PARAM_INT);
        $stmt->bindValue(':limit', (int)$this->limit, PDO::PARAM_INT);
        $stmt->bindValue(':offset', (int)$this->offset, PDO::PARAM_INT);

        if (!empty($this->search)) {
            $search = "%{$this->search}%"; // Wrap keyword with wildcards for LIKE
            $stmt->bindValue(':search', $search, PDO::PARAM_STR);
        }

        $stmt->execute();

        return $stmt;
    }

    public function deleteAlbum()
    {
        $sqlQuery = "DELETE FROM `rj_album` WHERE `rj_album_id` = :rj_album_id";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(":rj_album_id", $this->album_id);

        $stmt->execute();
        return $stmt;
    }

    public function getAlbum()
    {
        $sqlQuery = "SELECT * FROM " . $this->tbl . " 
             WHERE `rj_album_id` = :album_id";

        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(":album_id", $this->album_id);
        $stmt->execute();
        return $stmt;
    }


    public function albumList()
{
    $sqlQuery = "SELECT * FROM {$this->tbl} 
                 WHERE rj_artist_id = :artist_id 
                 AND rj_album_status = '1'";

    // Add search condition if a keyword is provided
    if (!empty($this->search)) {
        $sqlQuery .= " AND rj_ablum_title LIKE :search";
    }

    $sqlQuery .= " LIMIT :limit OFFSET :offset";

    $stmt = $this->conn->prepare($sqlQuery);

    // Bind required values
    $stmt->bindValue(':artist_id', (int)$this->artist_id, PDO::PARAM_INT);
    $stmt->bindValue(':limit', (int)$this->limit, PDO::PARAM_INT);
    $stmt->bindValue(':offset', (int)$this->offset, PDO::PARAM_INT);

    if (!empty($this->search)) {
        $search = "%{$this->search}%"; // Wrap keyword with wildcards for LIKE
        $stmt->bindValue(':search', $search, PDO::PARAM_STR);
    }

    $stmt->execute();

    return $stmt;
}


    public function artistAlbum()
    {
        $sqlQuery = "SELECT * FROM " . $this->tbl . " where `rj_artist_id` = :artist_id and `rj_album_status` = '1'";
        

        if (!empty($this->search)) {
            $sqlQuery .= " AND rj_ablum_title LIKE :title";
        }

        $sqlQuery .= " LIMIT :limit OFFSET :offset";

        $stmt = $this->conn->prepare($sqlQuery);

        if (!empty($this->search)) {
            $searchTerm = "%{$this->search}%";
            $stmt->bindParam(':title', $searchTerm, PDO::PARAM_STR);
        }

        $stmt->bindParam(':artist_id', $this->artist_id, PDO::PARAM_INT);
        $stmt->bindParam(':limit', $this->limit, PDO::PARAM_INT);
        $stmt->bindParam(':offset', $this->offset, PDO::PARAM_INT);

        $stmt->execute();
        return $stmt;
    }

    public function artistAllAlbum()
    {
        $sqlQuery = "SELECT * FROM " . $this->tbl . " where `rj_artist_id` = :artist_id";
        

        if (!empty($this->search)) {
            $sqlQuery .= " AND rj_ablum_title LIKE :title";
        }

        $sqlQuery .= " LIMIT :limit OFFSET :offset";

        $stmt = $this->conn->prepare($sqlQuery);

        if (!empty($this->search)) {
            $searchTerm = "%{$this->search}%";
            $stmt->bindParam(':title', $searchTerm, PDO::PARAM_STR);
        }

        $stmt->bindParam(':artist_id', $this->artist_id, PDO::PARAM_INT);
        $stmt->bindParam(':limit', $this->limit, PDO::PARAM_INT);
        $stmt->bindParam(':offset', $this->offset, PDO::PARAM_INT);

        $stmt->execute();
        return $stmt;
    }

    public function artistAllAlbumCount()
    {
        $sqlQuery = "SELECT * FROM " . $this->tbl . " where `rj_artist_id` = :artist_id ORDER BY rj_artist_id DESC";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(':artist_id', $this->artist_id, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt;
    }

    // public function allAlbumList()
    // {
    //     $sqlQuery = "SELECT * FROM ".$this->tbl." where `rj_album_status` = '1' LIMIT :limit OFFSET :offset";
    //     $stmt = $this->conn->prepare($sqlQuery);
    //     $stmt->bindParam(":limit", $this->limit, PDO::PARAM_INT);
    //     $stmt->bindParam(":offset", $this->offset, PDO::PARAM_INT);
    //     $stmt->execute();
    //     return $stmt;
    // }

    public function allAlbumList()
    {
        $sqlQuery = "SELECT * 
             FROM " . $this->tbl . " AS a
             WHERE a.rj_album_status = '1'
             AND a.approved_status = '1'  
             AND EXISTS (
                    SELECT 1 
                    FROM rj_song AS s
                    WHERE s.rj_song_ablum_id = a.rj_album_id
                      AND s.rj_song_isDeleted = '0'
               )
             ORDER BY a.rj_album_id DESC";


        // Add name condition if provided
        if (!empty($this->search)) {
            $sqlQuery .= " AND `rj_ablum_title` LIKE :title";
        }

        $sqlQuery .= " LIMIT :limit OFFSET :offset";

        $stmt = $this->conn->prepare($sqlQuery);

        // Bind name if it's set
        if (!empty($this->search)) {
            $searchTerm = "%{$this->search}%";
            $stmt->bindParam(':title', $searchTerm, PDO::PARAM_STR);
        }

        $stmt->bindParam(':limit', $this->limit, PDO::PARAM_INT);
        $stmt->bindParam(':offset', $this->offset, PDO::PARAM_INT);

        $stmt->execute();

        return $stmt;
    }


    public function AllAlbum()
    {
        $sqlQuery = "SELECT * FROM `rj_my_artist` JOIN rj_album ON rj_album.rj_artist_id = rj_my_artist.rj_artist_id WHERE rj_my_artist.rj_cus_id = '$this->cus_id'";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->execute();
        return $stmt;
    }

    public function AlbumDetail()
    {
        $sqlQuery = "SELECT * FROM `rj_album` 
        JOIN rj_artist ON rj_artist.rj_artist_id = rj_album.rj_artist_id 
        WHERE rj_album_id = '$this->album_id' ";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->execute();
        return $stmt;
    }

    public function AlbumSong()
    {
        // $sqlQuery = "SELECT * FROM `rj_song` WHERE rj_song_status = '1' AND rj_song_isDeleted = '0' AND 'approve_status' = '1' AND rj_song_ablum_id = '$this->album_id'";
        $sqlQuery = "
        SELECT *
        FROM rj_song
        WHERE rj_song_status = 1
          AND rj_song_isDeleted = 0
          AND approve_status = 1
          AND rj_song_ablum_id = :album_id
    ";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->bindParam(':album_id', $this->album_id, PDO::PARAM_INT);

        $stmt->execute();
        return $stmt;
    }

    public function AlbumViews()
    {
        $sqlQuery = "SELECT * FROM `rj_view_song` WHERE rj_album_id = '$this->album_id'";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->execute();
        return $stmt;
    }

    public function LikedSongs()
    {
        $sqlQuery = "SELECT * FROM `rj_like_song` WHERE `rj_cus_id` = '$this->cus_id' AND `rj_like_song_id` = '$this->song_id'";
        $stmt = $this->conn->prepare($sqlQuery);
        $stmt->execute();
        return $stmt;
    }
}
