<?php

use Firebase\JWT\ExpiredException;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;

function validateToken()
{
    global $artist_obj; // 🔥 Important: access DB model used in your APIs
    global $user_obj; // 🔥 Important: access DB model used in your APIs

    $secret_key = "EBEqjOBupNnWUYG9eQBGvUM8";
    $headers = getallheaders();

    if (preg_match('/Bearer\s(\S+)/', $headers['Authorization'] ?? $headers['authorization'] ?? '', $matches)) {

        $token = $matches[1];

        try {
            // Decode the JWT
            $decoded = JWT::decode($token, new Key($secret_key, 'HS512'));

            // Extract user info from token
            $user = $decoded->data ?? null;
            if (!$user || empty($user->id)) {
                die(json_encode(["status" => false, "msg" => "Invalid token payload"]));
            }

            // 🔥 DATABASE CHECK — validate user status
            $artistDetails = $artist_obj->ProfileDetail($user->id);

            if (!empty($artistDetails) && $artistDetails['rj_artist_status'] != 1) { 
                die(json_encode(["status" => false, "msg" => "Artist inactive or blocked"]));
            }

            $userDetails = $user_obj->ProfileDetail($user->id);
            $userDetails = $userDetails->fetch(PDO::FETCH_ASSOC);

            if (!empty($userDetails) && $userDetails['rj_cus_status'] != 1) { 
                die(json_encode(["status" => false, "msg" => "User inactive or blocked"]));
            }



            // If everything is OK → return decoded info
            return $decoded;

        } catch (ExpiredException $e) {
            die(json_encode(["status" => false, "msg" => "Token expired"]));
        } catch (Exception $e) {
            die(json_encode(["status" => false, "msg" => "Invalid token: " . $e->getMessage()]));
        }

    } else {
        die(json_encode(["status" => false, "msg" => "Bearer token not found"]));
    }
}
