<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
// include vendor
require '../../vendor/autoload.php';
use \Firebase\JWT\JWT;

header("Access-Control-Allow-Origin: *"); // Allow all origins
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// including files
include_once("../../config/Database.php");
include_once("../../models/Artist.php");
include_once("../../models/Content.php");
include_once("../../models/User.php");
include_once("../../models/Album.php");
include_once("../../models/Song.php");
include_once("../../models/Podcast.php");
require_once ('../../common/EmailUtility.php');




// db objects
$db = new Database();
$connection = $db->connect();

// initialization of model objects
$artist_obj = new Artist($connection);
$content_obj = new Content($connection);
$user_obj = new User($connection);
$song_obj = new Song($connection);
$album_obj = new Album($connection);
$podcast_obj = new Podcast($connection);
